<?php

namespace app\components;

use app\models\Song;

class SongService
{
    public function saveSongs($deviceId, $files)
    {
        foreach ($files as $file) {
            $this->saveSong($deviceId, $file);
        }

        $deviceService = new DeviceService();
        $deviceService->changeOccurred($deviceId, DeviceService::SONG_ADDED);
    }

    public function saveSong($deviceId, $file)
    {
        $song = new Song();
        $song->device_id = $deviceId;
        $name = $this->getSongNum($file->baseName, $deviceId) . '_' . $file->baseName . '.' . $file->extension;
        $song->name = $name;
        $song->save();

        if(!file_exists('uploads/' . $deviceId )) {
            mkdir('uploads/' . $deviceId, 0777);
        }
        $file->saveAs('uploads/' . $deviceId . '/' . $name);
    }

    protected function getSongNum($baseName, $deviceId)
    {
        $song = Song::find()
            ->where(['LIKE', 'name', $baseName])
            ->andWhere(['device_id'=>$deviceId])
            ->orderBy('id DESC')
            ->one();
        if($song) {
            $num = substr($song->name, 0, strpos($song->name, '_'));
            return (int)$num + 1;
        }
        return 1;
    }


    public function removeSong($songs)
    {
        $songIds = [];
        foreach($songs as $songItem) {
            $songIds[] = $songItem['song_id'];
        }

        $songs = Song::find()->where(['IN', 'id', $songIds])->all();
        if ($songs) {
            foreach($songs as $song) {
                unlink('uploads/' . $song->device_id . '/' . $song->name);
                $song->delete();
            }

            $deviceService = new DeviceService();
            $deviceService->changeOccurred(
                $songs[0]->device_id, DeviceService::SONG_REMOVED
            );
        }
    }

}