<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');


require './vendor/autoload.php';
use Parse\ParseClient;
use Parse\ParseObject;
use Parse\ParseQuery;
use Parse\ParseFile;

ParseClient::initialize(PARSE_APP_KEY, PARSE_REST_KEY, PARSE_MASTER_KEY);

class Servant extends MX_Controller{

    function __construct() {
        parent::__construct();
        if($this->session->userdata('sess_logged_in')!=true){
                redirect('login/index?error=4');
        }
    }


	function index(){
		$data=array();
		$scategory="";
		if(!empty($_GET["category"]))
			$scategory=$_GET["category"];
		$data['scategory']=$scategory;
		
		$query = new ParseQuery("Servant");
		if(!empty($scategory))
			$query->equalTo("subCategoryId",intval($scategory));
		$results = $query->find();
		$categorylist=array();
		$query = new ParseQuery("SubCategory");
		$categorylist=$query->find();
		$usercategory=array();
		foreach($results as $result){
			$subCateoryId=$result->get("subCategoryId");
			$categoryname="";
			foreach($categorylist as $category){
				if($category->get("subCategoryId")==$subCateoryId){
					$categoryname=$category->get("name");
					break;
				}
			}
			$usercategory[$result->getObjectId()]=$categoryname;
		}
		$data['servantlist']=$results;
		$data['categorylist']=$usercategory;
		$data['fclist']=$categorylist;
		$page_details['page_title']='Servant';
		$this->load->Module('header')->index($page_details);
		$this->load->view('servant',$data);
		$this->load->Module('sidebar')->index($page_details);
		$this->load->Module('footer')->index($page_details);
		$this->load->Module('jscode')->servant();
	}

	function edit($id){
		$categorylist=array();
		$query = new ParseQuery("SubCategory");
		$categorylist=$query->find();
		$data['categorylist']=$categorylist;
		$query = new ParseQuery("Servant");
		$servant=$query->get($id);
		$data['servant']=$servant;
		$page_details['page_title']='Servant - Edit';
		$this->load->Module('header')->index($page_details);
		$this->load->view('servant_edit',$data);
		$this->load->Module('sidebar')->index($page_details);
		$this->load->Module('footer')->index($page_details);
		$this->load->Module('jscode')->servant_edit();
	}

	function add(){
		$categorylist=array();
		$query = new ParseQuery("SubCategory");
		$categorylist=$query->find();
		$data['categorylist']=$categorylist;
		$page_details['page_title']='Servant - Add';
		$this->load->Module('header')->index($page_details);
		$this->load->view('servant_add',$data);
		$this->load->Module('sidebar')->index($page_details);
		$this->load->Module('footer')->index($page_details);
		$this->load->Module('jscode')->servant_add();
	}

	function delete_servant(){
		$id=$this->input->post('id');
		$query = new ParseQuery("Servant");
		$servant=$query->get($id);
		$servant->destroy();
		$response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
	}

	function add_servant(){
		$name=$this->input->post("name");
		$rating=$this->input->post("rating");
		$email=$this->input->post("email");
		$status=$this->input->post("status");
		$subcategory=$this->input->post("subCategory");
		$urgent=false;
		if(!empty($_POST["urgent"])){
			$urgent=true;
		}
		if ( isset( $_FILES['image'] ) ) {
			$file = ParseFile::createFromData( file_get_contents( $_FILES['image']['tmp_name'] ), $_FILES['image']['name']  );
			//echo($file);
			$file->save();
			
		}

		$query = new ParseQuery("Servant");
		$servant= new ParseObject("Servant");
		$servant->set("name",$name);
		$servant->set("rating",floatval($rating));
		$servant->set("email",$email);
		$servant->set("currentStatus",$status);
		$servant->set("subCategoryId",intval($subcategory));
		if(!empty($file))
			$servant->set("photo",$file);
		$servant->save();
		redirect('servant');
	}
	function edit_servant(){
		$id= $this->input->post("id");
		$name=$this->input->post("name");
		$rating=$this->input->post("rating");
		$email=$this->input->post("email");
		$status=$this->input->post("status");
		$subcategory=$this->input->post("subCategory");
		$urgent=false;
		if(!empty($_POST["urgent"])){
			$urgent=true;
		}

		if ( !empty( $_FILES['image']['tmp_name'] ) ) {
			$file = ParseFile::createFromData( file_get_contents( $_FILES['image']['tmp_name'] ), $_FILES['image']['name']  );
			//echo($file);
			$file->save();
			
		}

		$query = new ParseQuery("Servant");
		$servant=$query->get($id);
		$servant->set("name",$name);
		$servant->set("rating",floatval($rating));
		$servant->set("email",$email);
		$servant->set("currentStatus",$status);
		$servant->set("subCategoryId",intval($subcategory));
		if(!empty($file))
			$servant->set("photo",$file);
		$servant->save();
		redirect('servant');
	}

/*
    
	function edit_maincategory(){
		$id= $this->input->post("id");
		$name=$this->input->post("name");
		$desc=$this->input->post("desc");
		$urgent=false;
		if(!empty($_POST["urgent"])){
			$urgent=true;
		}
		if ( isset( $_FILES['image'] ) ) {
			$file = ParseFile::createFromData( file_get_contents( $_FILES['image']['tmp_name'] ), $_FILES['image']['name']  );
			//echo($file);
			$file->save();
			
		}

		$query = new ParseQuery("Category");
		$category=$query->get($id);
		$count = $query->count();

		$category->set("name",$name);
		$category->set("isAvailableUrgent",$urgent);
		$category->set("description",$desc);
		if(!empty($file))
				$category->set("image",$file);
		$category->set("categoryId",$count+1);
		$category->save();
		redirect('category/maincategory');
	}
	*/
}