<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require './vendor/autoload.php';
use Parse\ParseClient;
use Parse\ParseObject;
use Parse\ParseQuery;
use Parse\ParseFile;
use Parse\ParseUser;
use Parse\ParseGeoPoint;

ParseClient::initialize(PARSE_APP_KEY, PARSE_REST_KEY, PARSE_MASTER_KEY);

class Dashboard extends MX_Controller{

	function __construct() {
		parent::__construct();
		if($this->session->userdata('sess_logged_in')!=true){
			redirect('login/index');
		}


    }

    function index(){
    	$page_details['page_title']='Dashboard';
        $this->load->Module('header')->index($page_details);
		$data=array();
        
        $query=new ParseQuery("Category");
        $categorylist= $query->find();
        $data['categorylist']=$categorylist;
        
        $query=new ParseQuery("Order");
        $query->descending("createdAt");
        $orderlist= $query->find();
        $data['orderlist']=$orderlist;
        
        $query=new ParseQuery("Servant");
        $servantlist= $query->find();
        $data['servantlist']=$servantlist;
        
        $query= ParseUser::query();
        $query->descending("createdAt");
        $userlist= $query->find();
        $data['userlist'] = $userlist;
        
        //getting pending orders
        $pendinglist=array();
        foreach ($orderlist as $order) {
            if($order->get("status")=="PENDING" ){
                $pendinglist[]= $order;
            }
        }
        $markers=array();
        foreach($pendinglist as $pending){
            $mark= array();
            $geo=$pending->get("location");
            $latlong=array();
            $latlong[]=$geo->getLatitude();
            $latlong[]=$geo->getLongitude();
            $mark["latLng"]=$latlong;
            $mark["name"] = $pending->get("orderCategoryName");
            $markers[]=$mark;
        }
        $data['marker']=$markers;
        
    	$this->load->view('dashboard',$data);
		$this->load->Module('sidebar')->index($page_details);
		$this->load->Module('footer')->index($page_details);
		$this->load->Module('jscode')->dashboard();
    }

    function change_password(){
        $current_pass=$this->input->post('currentPassword');
        $new_pass=$this->input->post('newPassword');
        $confirm_pass=$this->input->post('confirmNewPassword');
        if($new_pass == $confirm_pass){
            //if new password is equal to confirm password
            //get user details
            $u_details=$this->mdl_general->GetInfoByRow('acs_user','u_id',array('u_id'=>$this->session->userdata('sess_user_id')));
            //check if the current password is correct
        if($u_details->u_password == $current_pass){
            //password match found and update password
            $this->mdl_general->Manage('acs_user',array('u_password'=>$new_pass),array('u_id'=>$this->session->userdata('sess_user_id')),'Update');
            $response=array(
                'status'=>'success',
                'message'=>'Password change successful'
                );
            //send response back to client
            $this->session->set_flashdata($response);
            redirect('dashboard');
        }else{
            //password doesnt match with database
            $response=array('status'=>'danger','message'=>'Incorrect password,try again!');
            $this->session->set_flashdata($response);
            redirect('dashboard');
        }


        }else{
            //new password is not equal to confirm password
            $response=array(
                'status'=>'danger',
                'message'=>'New password and Confirm password does not match'
                );
            $this->session->set_flashdata($response);
            redirect('dashboard');


        }
    }

}