<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');


require './vendor/autoload.php';
use Parse\ParseClient;
use Parse\ParseObject;
use Parse\ParseQuery;
use Parse\ParseFile;

ParseClient::initialize(PARSE_APP_KEY, PARSE_REST_KEY, PARSE_MASTER_KEY);

class Category extends MX_Controller{

    function __construct() {
        parent::__construct();
        if($this->session->userdata('sess_logged_in')!=true){
                redirect('login/index?error=4');
        }
    }


	function index(){
		return $this->maincategory();
	}

    function maincategory($type=null, $id=null){
		if($type == 'add'){
			//add view
			$page_details['page_title']='Main Category - Add';
			$this->load->Module('header')->index($page_details);
			$this->load->view('maincategory_add');
			$this->load->Module('sidebar')->index($page_details);
			$this->load->Module('footer')->index($page_details);
			$this->load->Module('jscode')->maincategory_add();
		} else if( $type == 'edit' && !empty($id)) {
			//edit view
			$query = new ParseQuery("Category");
			$category=$query->get($id);
			$data['category']=$category;
			$page_details['page_title']='Main Category - Edit';
			$this->load->Module('header')->index($page_details);
			$this->load->view('maincategory_edit',$data);
			$this->load->Module('sidebar')->index($page_details);
			$this->load->Module('footer')->index($page_details);
			$this->load->Module('jscode')->maincategory_edit();
		} else if(empty($type)) {
			//firstview
			$data=array();
			$query = new ParseQuery("Category");
			$results = $query->find();
			$data['categorylist']=$results;
			$page_details['page_title']='Main Category';
			$this->load->Module('header')->index($page_details);
			$this->load->view('maincategory',$data);
			$this->load->Module('sidebar')->index($page_details);
			$this->load->Module('footer')->index($page_details);
			$this->load->Module('jscode')->maincategory();
		}
	}

	function delete_maincategory(){
		$id=$this->input->post('id');
		$query = new ParseQuery("Category");
		$category=$query->get($id);
		$category->destroy();
		$response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
	}

	function add_maincategory(){
		$name=$this->input->post("name");
		$fee=$this->input->post("fee");
		$desc=$this->input->post("desc");
		$urgent=false;
		if(!empty($_POST["urgent"])){
			$urgent=true;
		}
		if ( !isset( $_FILES['image']['tmp_name'] ) ) {
			$file = ParseFile::createFromData( file_get_contents( $_FILES['image']['tmp_name'] ), $_FILES['image']['name']  );
			//echo($file);
			$file->save();
			
		}

		$query = new ParseQuery("Category");
		$count = $query->count();

		$category= new ParseObject("Category");
		$category->set("name",$name);
		$category->set("fee",$fee);
		$category->set("isAvailableUrgent",$urgent);
		$category->set("description",$desc);
		if(!isset($file))
				$category->set("image",$file);
		$category->set("categoryId",$count+1);
		$category->save();
		redirect('category/maincategory');
	}

	function edit_maincategory(){
		$id= $this->input->post("id");
		$name=$this->input->post("name");
		$fee=$this->input->post("fee");
		$desc=$this->input->post("desc");
		$urgent=false;
		if(!empty($_POST["urgent"])){
			$urgent=true;
		}
		if ( !empty( $_FILES['image']['tmp_name'] ) ) {
			$file = ParseFile::createFromData( file_get_contents( $_FILES['image']['tmp_name'] ), $_FILES['image']['name']  );
			//echo($file);
			$file->save();
			
		}

		$query = new ParseQuery("Category");
		$category=$query->get($id);

		$category->set("name",$name);
		$category->set("fee",$fee);
		$category->set("isAvailableUrgent",$urgent);
		$category->set("description",$desc);
		if(!empty($file))
				$category->set("image",$file);
		$category->save();
		redirect('category/maincategory');
	}

	function subcategory($type=null, $id=null){
		if($type == 'add'){
			//add view
			$page_details['page_title']='Sub Category - Add';
			$query = new ParseQuery("Category");
			$results = $query->find();
			$data['maincategorylist']=$results;
			$this->load->Module('header')->index($page_details);
			$this->load->view('subcategory_add',$data);
			$this->load->Module('sidebar')->index($page_details);
			$this->load->Module('footer')->index($page_details);
			$this->load->Module('jscode')->subcategory_add();
		} else if( $type == 'edit' && !empty($id)) {
			//edit view
			$query = new ParseQuery("SubCategory");
			$category=$query->get($id);
			$data['category']=$category;
			$query = new ParseQuery("Category");
			$results = $query->find();
			$data['maincategorylist']=$results;

			$page_details['page_title']='Sub Category - Edit';
			$this->load->Module('header')->index($page_details);
			$this->load->view('subcategory_edit',$data);
			$this->load->Module('sidebar')->index($page_details);
			$this->load->Module('footer')->index($page_details);
			$this->load->Module('jscode')->subcategory_edit();
		} else if(empty($type)) {
			//firstview
			$parent=$this->input->get("main");
			$data=array();
			$query = new ParseQuery("SubCategory");
			if(!empty($parent)){
				$query->equalTo("mainCategoryId",intval($parent));
			}
			$results = $query->find();
			$data['categorylist']=$results;

			$query = new ParseQuery("Category");
			$results = $query->find();
			$data['maincategorylist']=$results;

			$page_details['page_title']='Sub Category';
			$this->load->Module('header')->index($page_details);
			$this->load->view('subcategory',$data);
			$this->load->Module('sidebar')->index($page_details);
			$this->load->Module('footer')->index($page_details);
			$this->load->Module('jscode')->subcategory();
		}
	}

	function delete_subcategory(){
		$id=$this->input->post('id');
		$query = new ParseQuery("SubCategory");
		$category=$query->get($id);
		$category->destroy();
		$response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
	}

	function add_subcategory(){
		$name=$this->input->post("name");
		$desc=$this->input->post("desc");
		$mainCategory=$this->input->post("mainCategory");
		$urgent=false;
		if(!empty($_POST["urgent"])){
			$urgent=true;
		}
		if ( !empty( $_FILES['image']['tmp_name'] ) ) {
			$file = ParseFile::createFromData( file_get_contents( $_FILES['image']['tmp_name'] ), $_FILES['image']['name']  );
			//echo($file);
			$file->save();
			
		}

		$query = new ParseQuery("SubCategory");
		$count = $query->count();

		$category= new ParseObject("SubCategory");
		$category->set("name",$name);
		$category->set("isUrgentAvailable",$urgent);
		$category->set("description",$desc);
		$category->set("mainCategoryId",intval($mainCategory));
		if(!empty($file))
				$category->set("image",$file);
		$category->set("subCategoryId",$count+1);
		$category->save();
		redirect('category/subcategory');
	}

	function edit_subcategory(){
		$id= $this->input->post("id");
		$name=$this->input->post("name");
		$desc=$this->input->post("desc");
		$mainCategory=$this->input->post("mainCategory");
		$urgent=false;
		if(!empty($_POST["urgent"])){
			$urgent=true;
		}
		if ( !empty( $_FILES['image']['tmp_name'] ) ) {
			$file = ParseFile::createFromData( file_get_contents( $_FILES['image']['tmp_name'] ), $_FILES['image']['name']  );
			//echo($file);
			$file->save();
			
		}

		$query = new ParseQuery("SubCategory");
		$category=$query->get($id);

		$category->set("name",$name);
		$category->set("isUrgentAvailable",$urgent);
		$category->set("description",$desc);
		$category->set("mainCategoryId",intval($mainCategory));
		if(!empty($file))
				$category->set("image",$file);
		$category->save();
		redirect('category/subcategory');
	}

}