<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Transaction extends MX_Controller{

	///private $param = array("key"=>"xxxx");	//Get api_key from http://www.developers.contrib.com

	private $param = array("key"=>"a54c");

    function __construct() {
        parent::__construct();
        $this->load->model('mdl_general');
		////////////-survey-//////////////////
		$this->load->helper(array('form', 'url'));
	    $this->load->library('session');
	    $this->load->database();
	    $this->load->library('contribsurvey',$this->param);
		////////////-survey-//////////////////
        if($this->session->userdata('sess_logged_in')!=true){
                redirect('login/index?error=4');
        }


    }

     function user($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | User edit";
            $data['user']=$this->mdl_general->GetInfoByRow('acs_user','u_id',array('u_id'=>$id));
            $data['user_list']=$this->mdl_general->GetAllInfo('acs_user','u_id');
            $data['permissions']=$this->mdl_general->GetAllInfo('acs_userd','u_id',array('u_id'=>$id));

			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('user_edit',$data);
			$this->load->module('footer')->index($page_details);

        }else{
            $page_details['page_title']="ONYX TECH | Users";
            $data['user_list']=$this->mdl_general->GetAllInfo('acs_user','u_id');

			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('user',$data);
			$this->load->module('footer')->index($page_details);
        }
    }

    function delete_user(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('acs_user',array('u_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);

    }

    function add_new_user(){
        $enabled=$this->input->post('enabled');
        $supervisor_id=$this->input->post('supervisor');
        $form_data=array(
            'u_name'=>$this->input->post('name'),
            'u_email'=>$this->input->post('email'),
            'u_logname'=>$this->input->post('logName'),
            'u_password'=>$this->input->post('password'),
            'u_remarks'=>$this->input->post('remark'),
            'u_cellno'=>$this->input->post('cell'),
            'role_id'=>$this->input->post('roleSlug'),
            'u_loginfdate'=>date('Y-m-d',strtotime($this->input->post('loginFrom'))),
            'u_logintodate'=>date('Y-m-d',strtotime($this->input->post('loginTo'))),
            'su_id'=>( $supervisor_id ? $supervisor_id :'0'),
            'u_enabled'=>( $enabled ? $enabled :'0')
        );
        $user_id=$this->mdl_general->SaveForm('acs_user',$form_data);
        $services=$this->input->post('services');
        foreach ($services as $key => $value) {
            $this->mdl_general->SaveForm('dn_services_providers',array('id_users'=>$user_id,'id_services'=>$value));

        }

        $response=array(
            'status'=>'success',
            'message'=>'User added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('transaction/user');


    }

    function user_edit(){
        $enabled=$this->input->post('enabled');
        $supervisor_id=$this->input->post('supervisor');
        $id=$this->input->post('hdnUserId');
        $services=$this->input->post('services');
        $form_data=array(
            'u_name'=>$this->input->post('name'),
            'u_email'=>$this->input->post('email'),
            'u_logname'=>$this->input->post('logName'),
            'u_password'=>$this->input->post('password'),
            'u_remarks'=>$this->input->post('remark'),
            'role_id'=>$this->input->post('roleSlug'),
            'u_cellno'=>$this->input->post('cell'),
            'u_loginfdate'=>date('Y-m-d',strtotime($this->input->post('loginFrom'))),
            'u_logintodate'=>date('Y-m-d',strtotime($this->input->post('loginTo'))),
            'su_id'=>( $supervisor_id ? $supervisor_id :'0'),
            'u_enabled'=>( $enabled ? $enabled :'0')
        );
        $this->mdl_general->Manage('acs_user',$form_data,array('u_id'=>$id),'Update');

        $this->mdl_general->Delete('dn_services_providers',array('id_users'=>$id));
        foreach ($services as $key => $value) {
            $this->mdl_general->SaveForm('dn_services_providers',array('id_users'=>$id,'id_services'=>$value));

        }
        $response=array(
            'status'=>'success',
            'message'=>'User updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('transaction/user');
    }

    function insert_user_permission(){
        $form_data=array(
            'menu_id'=>$this->input->post('menu_id'),
            'u_add'=>$this->input->post('menu_add'),
            'u_edit'=>$this->input->post('menu_edit'),
            'u_del'=>$this->input->post('menu_del'),
            'u_view'=>$this->input->post('menu_view'),
            'u_id'=>$this->input->post('hdnUserId'),
            );
        $this->mdl_general->SaveForm('acs_userd',$form_data);
        $response=array(
            'status'=>'success',
            'message'=>'User permission added successfully'
            );
        echo json_encode($response);
    }

    function  get_user_permissions(){
        $id=$this->input->post('user_id');
        $permissions=$this->mdl_general->GetAllInfo('acs_userd','u_id',array('u_id'=>$id));
        echo json_encode($permissions);
    }

    function delete_user_permission($user_id,$menu_id){

        $this->mdl_general->Delete('acs_userd',array('u_id'=>$user_id,'menu_id'=>$menu_id));
        $response=array(
            'status'=>'success',
            'message'=>'User permission deleted successfully'
            );
        $this->session->set_flashdata($response);
        redirect('transaction/user/edit/'.$user_id);
    }

    function change_user_permission(){
        $type=$this->input->post('type');
        $menu_id=$this->input->post('menu_id');
        $user_id=$this->input->post('user_id');
        $value=$this->input->post('value');
        if($type=='add'){
            $this->mdl_general->Manage('acs_userd',array('u_add'=>$value),array('menu_id'=>$menu_id,'u_id'=>$user_id),'Update');
            $response=array(
                'status'=>'success',
                'message'=>'User permission updated successfully'
            );
            echo json_encode($response);

        }elseif($type=='edit'){
            $this->mdl_general->Manage('acs_userd',array('u_edit'=>$value),array('menu_id'=>$menu_id,'u_id'=>$user_id),'Update');
            $response=array(
                'status'=>'success',
                'message'=>'User permission updated successfully'
            );
            echo json_encode($response);

        }elseif($type=='view'){
            $this->mdl_general->Manage('acs_userd',array('u_view'=>$value),array('menu_id'=>$menu_id,'u_id'=>$user_id),'Update');
            $response=array(
                'status'=>'success',
                'message'=>'User permission updated successfully'
            );
            echo json_encode($response);

        }elseif($type=='del'){
            $this->mdl_general->Manage('acs_userd',array('u_del'=>$value),array('menu_id'=>$menu_id,'u_id'=>$user_id),'Update');
            $response=array(
                'status'=>'success',
                'message'=>'User permission updated successfully'
            );
            echo json_encode($response);

        }
    }

    function user_roles($type=null,$id=null){
        if($type=='edit' && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Edit User Roles";
            $data['role_data']=$this->mdl_general->GetInfoByRow('acs_user_roles','role_id',array('role_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('user_roles_edit',$data);
			$this->load->module('footer')->index($page_details);


        }else{
            $page_details['page_title']="ONYX TECH | User Roles";
            $data['roles_list']=$this->mdl_general->GetAllInfo('acs_user_roles','role_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('user_roles',$data);
			$this->load->module('footer')->index($page_details);
        }
    }


    function add_new_user_role(){
        $active=$this->input->post('active');
        $default=$this->input->post('default');
        $form_data=array(
            'slug'=>strtolower($this->input->post('slug')),
            'active'=>( $active ? $active :'0'),
            'default'=>( $default ? $default :'0')
        );
        $role_id=$this->mdl_general->SaveForm('acs_user_roles',$form_data);
        $response=array(
            'status'=>'success',
            'message'=>'User role added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('transaction/user_roles');
    }

    function edit_user_role(){
        $active=$this->input->post('active');
        $default=$this->input->post('default');
        $id=$this->input->post('hdnRoleId');
        $form_data=array(
            'slug'=>strtolower($this->input->post('slug')),
            'active'=>( $active ? $active :'0'),
            'default'=>( $default ? $default :'0')
        );
        $role_id=$this->mdl_general->Manage('acs_user_roles',$form_data,array('role_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'User role updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('transaction/user_roles');
    }


    function delete_user_role(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('acs_user_roles',array('role_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

    function get_client_detail(){
        $this->load->model('mdl_extra');
        $data=$this->mdl_extra->get_matching_client($this->input->post('name'));
        echo json_encode($data);
    }

    //for sending sms

    function sendSms($status=null){
        if($status=="success"){
            $page_details['page_title']="ONYX TECH | Send Email";

			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('send_sms_success');
			$this->load->module('footer')->index($page_details);


        }else{
            $page_details['page_title']="ONYX TECH | Send Email";
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('send_sms');
			$this->load->module('footer')->index($page_details);
        }
    }

    function rep_send_sms_filter(){
        $this->load->model('mdl_extra');
        $donation_sms=$this->input->post('bodySMS');
        //$top_donation=$this->input->post('topDonation');
        ($this->input->post('donorEmail') ? $donor_email="1" : $donor_email="donor_sendmail");
        ($this->input->post('donorTextAlert') ? $donor_text_alert="1" : $donor_text_alert="donor_textalert");
        ($this->input->post('donorBoxDonor') ? $donor_box_donor="1" : $donor_box_donor="donor_box");
        ($this->input->post('donorVIP') ? $donor_vip="1" : $donor_vip="donor_vip");
        ($this->input->post('donorCardSend') ? $donor_card_send="1" : $donor_card_send="donor_cardsend");
        ($this->input->post('donorNews') ? $donor_news="1" : $donor_news="donor_sendnews");
        ($this->input->post('donorDataSharing') ? $donor_data_sharing="1" : $donor_data_sharing="donor_sharedata");
        ($this->input->post('donorMuslim') ? $donor_muslim="1" : $donor_muslim="donor_muslim");
        ($this->input->post('donorCommittee') ? $donor_committee="1" : $donor_committee="donor_committee");
        ($this->input->post('donorMailOfficeAddress') ? $donor_mail_office="1" : $donor_mail_office="donor_homeletter");
        $donor_city=$this->input->post('donorCity');
        if($this->input->post('fromAmount') ==""){
            $from_amount="dnd.donation_amount";
        }else{
            $from_amount=$this->input->post('fromAmount');
        }
        if($this->input->post('toAmount') ==""){
            $to_amount="dnd.donation_amount";
        }else{
            $to_amount=$this->input->post('toAmount');
        }

        if($this->input->post('fromDate') !=""){
            $from_date=date('Y-m-d',strtotime($this->input->post('fromDate')));
        }else{
            $from_date="dn.donation_date";
        }
        if($this->input->post('toDate') != ""){
            $to_date=date('Y-m-d',strtotime($this->input->post('toDate')));
        }else{
            $to_date="dn.donation_date";
        }

        if($this->input->post('homeCity')){
            if($donor_city =="0"){
                $donor_city="d.donor_homecityid";
                $city_name="All";
            }
            $donor_city="d.donor_homecityid=".$donor_city;

        }else{
            if($donor_city =="0"){
                $donor_city="d.donor_officecity";
                $city_name="All";
            }
            $donor_city="d.donor_officecity=".$donor_city;

        }

        if($this->input->post('save')){
            $this->mdl_general->Manage('acs_configration',array('donationsmstext'=>$donation_sms),array('config_id'=>"1"),'Update');
            $this->session->set_flashdata('sms_status','Configuration has been updated successfully.');
            redirect('transaction/sendSms/success');

        }elseif($this->input->post('send')){
            $data['list']=$this->mdl_extra->GetDonorForSMS($donor_email,$donor_text_alert,$donor_box_donor,$donor_vip,$donor_card_send,$donor_news,$donor_data_sharing,$donor_muslim,$donor_committee,$donor_mail_office,$from_amount,$to_amount,$from_date,$to_date,$donor_city);
            $delivered_sms = "";
            foreach($data['list'] as $row){
                if($this->input->post('homeCity')){
                    $address = $row['donorhome_address'];
                    $city = $row['homecity'];
                    $phone = $row['donor_homephone'];
                    $postcode = $row['donor_postcode'];
                }else{
                    $address = $row['donor_officeaddress'];
                    $city = $row['officecity'];
                    $phone = $row['donor_officephone'];
                    $postcode = $row['donor_officepostcode'];
                }
                $sms = str_replace("{donorid}",$row['donor_id'],$donation_sms);
                $sms = str_replace("{donationamount}",$row['donation_amount'],$sms);
                $sms = str_replace("{donornamefirst}",$row['donor_namef'],$sms);
                $sms = str_replace("{donornamemiddle}",$row['donor_namem'],$sms);
                $sms = str_replace("{donornamelast}",$row['donor_namel'],$sms);
                $sms = str_replace("{donoraddress}",$address,$sms);
                $sms = str_replace("{city}",$city,$sms);
                $sms = str_replace("{postcode}",$postcode,$sms);
                $sms = str_replace("{cellnumber}",$row['donor_mobile'],$sms);
                $sms = str_replace("{phone}",$phone,$sms);
                $sms = str_replace("{title}",$row['title_name'],$sms);
                $sms = str_replace("{email}",$row['donor_email'],$sms);
                $sms = str_replace("{donationid}",$row['donation_id'],$sms);
                if($row['donor_mobile']!=""){
                    $url = "http://www.voodoosms.com/vapi/server/sendSMS?";
                     //Post variable names should be same as mentioned below example and its case sensitive as well
                    $message=urlencode($sms);
                    $url .='dest=44'.$row['donor_mobile'];
                    $url .='&orig=Ucare';
                    $url .='&msg='.$message;
                    $url .='&uid=ONYXTECH';
                    $url .='&pass=3qo4w7d';
                    $url .='&validity=1';
                    $url .='&format=php';
                    $to=$row['donor_namef']." ".$row['donor_namem']." ".$row['donor_namel'];

                    $ch = curl_init($url);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    $response = curl_exec($ch);
                    curl_close($ch);
                    $delivered_sms.="SMS has been sent to:".$to."  <br />";
                }

            }
            $this->session->set_flashdata('sms_status',$delivered_sms);
            redirect('transaction/sendSms/success');


        }
    }


    //for sending email
     function sendEmail($status=null){
        if($status=="success"){
            $page_details['page_title']="ONYX TECH | Send Email";

			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('send_email_success');
			$this->load->module('footer')->index($page_details);


        }else{
            $page_details['page_title']="ONYX TECH | Send Email";
            $this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('send_email');
			$this->load->module('footer')->index($page_details);
        }
     }

     function rep_send_email_filter(){
        $this->load->model('mdl_extra');
        ($this->input->post('donorEmail') ? $donor_email="1" : $donor_email="donor_sendmail");
        ($this->input->post('donorTextAlert') ? $donor_text_alert="1" : $donor_text_alert="donor_textalert");
        ($this->input->post('donorBoxDonor') ? $donor_box_donor="1" : $donor_box_donor="donor_box");
        ($this->input->post('donorVIP') ? $donor_vip="1" : $donor_vip="donor_vip");
        ($this->input->post('donorCardSend') ? $donor_card_send="1" : $donor_card_send="donor_cardsend");
        ($this->input->post('donorNews') ? $donor_news="1" : $donor_news="donor_sendnews");
        ($this->input->post('donorDataSharing') ? $donor_data_sharing="1" : $donor_data_sharing="donor_sharedata");
        ($this->input->post('donorMuslim') ? $donor_muslim="1" : $donor_muslim="donor_muslim");
        ($this->input->post('donorCommittee') ? $donor_committee="1" : $donor_committee="donor_committee");
        ($this->input->post('donorMailOfficeAddress') ? $donor_mail_office="1" : $donor_mail_office="donor_homeletter");
        $donor_city=$this->input->post('donorCity');
        $donor_type=$this->input->post('donorType');
        $donor_event=$this->input->post('donorEvent');
        if($this->input->post('fromAmount') ==""){
            $from_amount="dnd.donation_amount";
        }else{
            $from_amount=$this->input->post('fromAmount');
        }
        if($this->input->post('toAmount') ==""){
            $to_amount="dnd.donation_amount";
        }else{
            $to_amount=$this->input->post('toAmount');
        }

        if($this->input->post('fromDate') == ""){
            $from_date="dn.donation_date";
        }else{
            $from_date=date('Y-m-d',strtotime($this->input->post('fromDate')));
        }
        if($this->input->post('toDate')== ""){
            $to_date="dn.donation_date";

        }else{
            $to_date=date('Y-m-d',strtotime($this->input->post('toDate')));
        }

        if($this->input->post('homeCity')){
            if($donor_city =="0"){
                $donor_city="d.donor_homecityid";
                $city_name="All";
            }
            $donor_city="d.donor_homecityid=".$donor_city;

        }else{
            if($donor_city =="0"){
                $donor_city="d.donor_officecity";
                $city_name="All";
            }
            $donor_city="d.donor_officecity=".$donor_city;

        }
        if($donor_type=="0"){
            $donor_type = "d.donortype_id";
            $donor_type_name="All";
        }

        if($donor_event =="0"){
            $donor_event="dnd.event_id";
            $event_name="All";
        }
        $image="";
        if(@$_FILES['imageEmail']['name'] != ""){
            $config['upload_path'] = FCPATH . 'assets/image/email_images/';
            $config['allowed_types'] = 'jpeg|png|jpg|PNG|JPG|bmp|BMP';
            $config['encrypt_name'] = FALSE;
            $config['remove_spaces'] = FALSE;
            $config['max_size'] = '2048000';
            $this->upload_file($config,'imageEmail');
            $image=$_FILES['imageEmail']['name'];
        }


        $deliveryStatus = "";
        $emailtext = str_replace(chr(10), '<br>', $this->input->post('bodyEmail'));
        $data['list']=$this->mdl_extra->GetDonorForEmail($donor_email,$donor_text_alert,$donor_box_donor,$donor_vip,$donor_card_send,$donor_news,$donor_data_sharing,$donor_muslim,$donor_committee,$donor_mail_office,$from_amount,$to_amount,$from_date,$to_date,$donor_city,$donor_type,$donor_event);
        $sender=$this->mdl_general->GetInfoByRow('acs_configration','config_id',array('config_id'=>"1"));
        $this->load->library('email');
        $subject=$this->input->post('headerEmail');


        if(count($data['list']) >0){
            foreach($data['list'] as $row){
                if($this->input->post('homeCity')){
                    $address = $row['donorhome_address'];
                    $city = $row['hcity'];
                    $phone = $row['donor_homephone'];
                    $postcode = $row['donor_postcode'];
                }else{
                    $address = $row['donor_officeaddress'];
                    $city = $row['ofcity'];
                    $phone = $row['donor_officephone'];
                    $postcode = $row['donor_officepostcode'];
                }
                $emailtext = str_replace("{title}",$row['title_name'],$emailtext);
                $emailtext = str_replace("{donornamefirst}",$row['donor_namef'],$emailtext);
                $emailtext = str_replace("{donornamemiddle}",$row['donor_namem'],$emailtext);
                $emailtext = str_replace("{donornamelast}",$row['donor_namel'],$emailtext);
                $emailtext = str_replace("{donoraddress}",$address,$emailtext);
                $emailtext = str_replace("{city}",$city,$emailtext);
                $emailtext = str_replace("{postcode}",$postcode,$emailtext);
                $emailtext = str_replace("{cellnumber}",$row['donor_mobile'],$emailtext);
                $emailtext = str_replace("{phone}",$phone,$emailtext);
                $emailtext = str_replace("{email}",$row['donor_email'],$emailtext);
                $emailtext = str_replace("{event}",$row['event_name'],$emailtext);
                $message ='<html><head></head><body><p>'.$emailtext.'</p>';

                if($image!=""){
                    $message.='<p><img src="'.base_url().'assets/image/email_images/'.$image.'" /></p><br/>';
                }
                $message.='<p>'.str_replace(chr(10), '<br>', $sender->signaturetext).'</p><p><img width="160px" src="'.base_url().'assets/image/setUpwindow/'.$sender->signatureimage.'" /></p></body></html>';


                $config['useragent']  = "CodeIgniter";
                $config['mailpath']  = "/usr/sbin/sendmail"; // or "/usr/sbin/sendmail"
                $config['protocol']   = "sendmail";
                $config['mailtype'] = 'html';
                $config['charset']  = 'utf-8';
                $config['newline']  = "\r\n";
                $config['wordwrap'] = TRUE;
                $config['validate']=TRUE;
                $this->email->initialize($config);
                $this->email->from($sender->emailsenderaddress,$sender->emailsendername);
                $this->email->to($row['donor_email']);
                $this->email->subject($subject);
                $this->email->message($message);

                if($this->email->send()){
                    //echo $deliveryStatus.=$this->email->print_debugger();
                    $deliveryStatus.="Email has been sent to:".$to."<br />";
                }else{
                    $deliveryStatus.="Email sending failed to:".$to."<br />";
                }

                $this->email->clear();

            }
        }else{
            $deliveryStatus.="No recepient to send email.";
        }



        $this->session->set_flashdata('email_status',$deliveryStatus);
        redirect('transaction/sendEmail/success');

     }

    function upload_file($config, $fieldname) {
        $this->load->library('upload');
        $this->upload->initialize($config);
        $this->upload->do_upload($fieldname);
    }
//price
	function appointment($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Appointment edit";
            $data['appointment_details']=$this->mdl_general->GetInfoByRow('tblappointment','ap_id',array('ap_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('appointment_edit',$data);
			$this->load->module('footer')->index($page_details);

        }else{

			$page_details['page_title']="ONYX TECH | Appointment";
			$data['appointment_list']=$this->mdl_general->GetAllInfo('tblappointment','ap_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('appointment',$data);
			$this->load->module('footer')->index($page_details);
		}
    }

    function add_new_appointment(){
        $active=$this->input->post('ap_active');
        $form_data=array(

            'ap_name'=>$this->input->post('ap_name'),
			'ap_enq'=>$this->input->post('ap_enq'),
			'ap_landlord'=>$this->input->post('ap_landlord'),
			'ap_datetime' => date('Y-m-d H:i:s',strtotime($this->input->post('ap_date').$this->input->post('ap_time'))),
            'ap_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->SaveForm('tblappointment',$form_data);
        $response=array(
            'appointment'=>'success',
            'message'=>'appointment added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('transaction/appointment');

    }

    function delete_appointment(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('tblappointment',array('ap_id'=>$id));
        $response=array(
            'appointment'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

    function appointment_edit(){
        $active=$this->input->post('ap_active');
        $id=$this->input->post('ap_id');
        $form_data=array(

            'ap_name'=>$this->input->post('ap_name'),
			'ap_enq'=>$this->input->post('ap_enq'),
			'ap_landlord'=>$this->input->post('ap_landlord'),
			'ap_datetime' => date('Y-m-d H:i:s',strtotime($this->input->post('ap_date').$this->input->post('ap_time'))),
            'ap_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->Manage('tblappointment',$form_data,array('ap_id'=>$id),'Update');
        $response=array(
            'appointment'=>'success',
            'message'=>'Price updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('transaction/appointment');
    }

/*
    function appointment($appointment_hash = ''){
        $this->load->model('mdl_providers');
        $this->load->model('mdl_services');
        $this->load->model('mdl_customer');
        $this->load->model('mdl_appointments');
        $this->lang->load('translations', $this->config->item('language'));
        $page_details['page_title']="ONYX TECH | Appointment";
        $this->load->module('header')->index($page_details);
        $data['available_providers']=$this->mdl_providers->GetAvailableProviders();
        $data['available_services']=$this->mdl_services->GetAvailableServices();
        $data['book_advance_timeout']=$this->mdl_general->GetInfoByRow('dn_appointment_settings','id',array('name'=>'book_advance_timeout'))->value;
        $results = $this->mdl_appointments->get_batch(array('hash' => $appointment_hash));
        if ($appointment_hash != '' && count($results) > 0) {
            $appointment = $results[0];
            $appointment['customer'] = $this->mdl_customer->get_row($appointment['id_meeting_client']);
            $data['edit_appointment'] = $appointment; // This will display the appointment edit dialog on page load.
        } else {
            $data['edit_appointment'] = NULL;
        }
        $data['user_id'] = $this->session->userdata('sess_user_id');
        $data['user_email'] = $this->session->userdata('sess_user_email');
        $data['role_slug'] = $this->session->userdata('sess_role_slug');
        $data['customers']=$this->mdl_customer->get_batch();

		$this->load->module('sidebar')->index($page_details);
		$this->load->view('appointment_calendar',$data);
		//$this->load->module('footer')->index($page_details);
    }

    function get_available_services_user(){
        echo json_encode($this->mdl_general->GetAllInfo('dn_services','service_id'));
    }

    function ajax_save_appointment(){
        try {
            $this->load->model('mdl_appointments');
            $this->load->model('mdl_providers');
            $this->load->model('mdl_services');
            $this->load->model('mdl_customer');
            //$this->load->model('settings_model');

            // :: SAVE CUSTOMER CHANGES TO DATABASE
            if (isset($_POST['customer_data'])) {
                $customer = json_decode(stripcslashes($_POST['customer_data']), true);
                $customer['client_id'] = $customer['client_id'];
            }

            // :: SAVE APPOINTMENT CHANGES TO DATABASE
            if (isset($_POST['appointment_data'])) {
                $appointment = json_decode(stripcslashes($_POST['appointment_data']), true);
                $manage_mode = isset($appointment['id']);
                // // If the appointment does not contain the customer record id, then it
                // // means that is is going to be inserted. Get the customer's record id.
                if (!isset($appointment['id_meeting_client'])) {
                     $appointment['id_meeting_client'] = $customer['client_id'];
                }

                $appointment['id'] = $this->mdl_appointments->add($appointment);
            }

            $appointment = $this->mdl_appointments->get_row($appointment['id']);
            $provider = $this->mdl_providers->get_row($appointment['id_meeting_lead']);
            $customer = $this->mdl_customer->get_row($appointment['id_meeting_client']);
            $service = $this->mdl_services->get_row($appointment['id_services']);

            // $company_settings = array(
            //     'company_name' => $this->settings_model->get_setting('company_name'),
            //     'company_link' => $this->settings_model->get_setting('company_link'),
            //     'company_email' => $this->settings_model->get_setting('company_email')
            // );



            // :: SEND EMAIL NOTIFICATIONS TO PROVIDER AND CUSTOMER
            // try {
            //     $this->load->library('Notifications');

            //     $send_provider = $this->providers_model
            //                 ->get_setting('notifications', $provider['id']);

            //     if (!$manage_mode) {
            //         $customer_title = $this->lang->line('appointment_booked');
            //         $customer_message = $this->lang->line('thank_your_for_appointment');
            //         $customer_link = $this->config->item('base_url') . 'appointments/index/'
            //                 . $appointment['hash'];

            //         $provider_title = $this->lang->line('appointment_added_to_your_plan');
            //         $provider_message = $this->lang->line('appointment_link_description');
            //         $provider_link = $this->config->item('base_url') . 'backend/index/'
            //                 . $appointment['hash'];
            //     } else {
            //         $customer_title = $this->lang->line('appointment_changes_saved');
            //         $customer_message = '';
            //         $customer_link = $this->config->item('base_url') . 'appointments/index/'
            //                 . $appointment['hash'];

            //         $provider_title = $this->lang->line('appointment_details_changed');
            //         $provider_message = '';
            //         $provider_link = $this->config->item('base_url') . 'backend/index/'
            //                 . $appointment['hash'];
            //     }

            //     $this->notifications->send_appointment_details($appointment, $provider,
            //             $service, $customer, $company_settings, $customer_title,
            //             $customer_message, $customer_link, $customer['email']);

            //     if ($send_provider == TRUE) {
            //         $this->notifications->send_appointment_details($appointment, $provider,
            //                 $service, $customer, $company_settings, $provider_title,
            //                 $provider_message, $provider_link, $provider['email']);
            //     }

            // } catch(Exception $exc) {
            //     $warnings[] = exceptionToJavaScript($exc);
            // }

            if (!isset($warnings)) {
                echo json_encode('SUCCESS');
            } else {
                echo json_encode(array(
                    'warnings' => $warnings
                ));
            }
        } catch(Exception $exc) {
            echo json_encode(array(
                'exceptions' => array(exceptionToJavaScript($exc))
            ));
        }
    }

    function ajax_get_calendar_appointments(){
        try {

            $this->load->model('mdl_appointments');
            $this->load->model('mdl_providers');
            $this->load->model('mdl_services');
            $this->load->model('mdl_customer');

//            if ($_POST['filter_type'] == 'provider') {
//                $where_id = 'id_meeting_lead';
//            } else {
//                $where_id = 'id_services';
//            }

			$where_id = 'id_services';
            // Get appointments
            $where_clause = array(
                $where_id => $_POST['record_id'],
                //'start_datetime >=' => $_POST['start_date'],
                //'end_datetime <=' => $_POST['end_date'],
                'is_unavailable' => FALSE
            );

            $response['appointments'] = $this->mdl_appointments->get_batch($where_clause);

            foreach($response['appointments'] as &$appointment) {
                $appointment['provider'] = $this->mdl_providers->get_row($appointment['id_meeting_lead']);
                $appointment['service'] = $this->mdl_services->get_row($appointment['id_services']);
                $appointment['customer'] = $this->mdl_customer->get_row($appointment['id_meeting_client']);
            }

            // Get unavailable periods (only for provider).
            if ($_POST['filter_type'] == 'provider') {
                $where_clause = array(
                    $where_id => $_POST['record_id'],
                    //'start_datetime >=' => $_POST['start_date'],
                    //'end_datetime <=' => $_POST['end_date'],
                    'is_unavailable' => TRUE
                );

                $response['unavailables'] = $this->mdl_appointments->get_batch($where_clause);
            }

            echo json_encode($response);

        } catch(Exception $exc) {
            echo json_encode(array(
                'exceptions' => array(exceptionToJavaScript($exc))
            ));
        }
    }

    function ajax_delete_appointment(){
        try {
            if (!isset($_POST['appointment_id'])) {
                throw new Exception('No appointment id provided.');
            }

            // :: STORE APPOINTMENT DATA FOR LATER USE IN THIS METHOD
            $this->load->model('mdl_appointments');
            $this->load->model('mdl_providers');
            $this->load->model('mdl_customer');
            $this->load->model('mdl_services');

            $appointment = $this->mdl_appointments->get_row($_POST['appointment_id']);
            $provider = $this->mdl_providers->get_row($appointment['id_meeting_lead']);
            $customer = $this->mdl_customer->get_row($appointment['id_meeting_client']);
            $service = $this->mdl_services->get_row($appointment['id_services']);

            // $company_settings = array(
            //     'company_name' => $this->settings_model->get_setting('company_name'),
            //     'company_email' => $this->settings_model->get_setting('company_email'),
            //     'company_link' => $this->settings_model->get_setting('company_link')
            // );

            // :: DELETE APPOINTMENT RECORD FROM DATABASE
            $this->mdl_appointments->delete($_POST['appointment_id']);


            // // :: SEND NOTIFICATION EMAILS TO PROVIDER AND CUSTOMER
            // try {
            //     $this->load->library('Notifications');

            //     $send_provider = $this->providers_model
            //                 ->get_setting('notifications', $provider['id']);

            //     if ($send_provider == TRUE) {
            //         $this->notifications->send_delete_appointment($appointment, $provider,
            //                 $service, $customer, $company_settings, $provider['email'],
            //                 $_POST['delete_reason']);
            //     }

            //     $this->notifications->send_delete_appointment($appointment, $provider,
            //             $service, $customer, $company_settings, $customer['email'],
            //             $_POST['delete_reason']);
            // } catch(Exception $exc) {
            //     $warnings[] = exceptionToJavaScript($exc);
            // }

            // :: SEND RESPONSE TO CLIENT BROWSER
            if (!isset($warnings)) {
                echo json_encode('SUCCESS'); // Everything executed successfully.
            } else {
                echo json_encode(array(
                    'warnings' => $warnings // There were warnings during the operation.
                ));
            }
        } catch(Exception $exc) {
            echo json_encode(array(
                'exceptions' => array(exceptionToJavaScript($exc))
            ));
        }
    }

    function ajax_delete_unavailable(){
        try {
            $this->load->model('mdl_appointments');
            $this->load->model('mdl_providers');

            $unavailable = $this->mdl_appointments->get_row($_POST['unavailable_id']);
            $provider = $this->mdl_providers->get_row($unavailable['id_meeting_lead']);

            // Delete unavailable
            $this->mdl_appointments->delete_unavailable($unavailable['id']);



            if (isset($warnings)) {
                echo json_encode(array(
                    'warnings' => $warnings
                ));
            } else {
                echo json_encode('SUCCESS');
            }

        } catch(Exception $exc) {
            echo json_encode(array(
                'exceptions' => array(exceptionToJavaScript($exc))
            ));
        }
    }
*/
	 function property($type=null,$id=null){
        if(!is_null($type)&& $type=="edit" && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Property Edit";
			$data['info']=$this->mdl_general->GetAllInfo('tblproperty','p_id',array("p_id"=>$id))[0];
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('property_edit',$data);
			$this->load->module('footer')->index($page_details);
		} else if(!is_null($type) && $type=="add") {
			 $page_details['page_title']="ONYX TECH | Property add";
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('property_add');
			$this->load->module('footer')->index($page_details);

        }else{
            $page_details['page_title']="ONYX TECH | Properties";
			$data['property_list']=$this->mdl_general->GetAllInfo('tblproperty','p_id',array("p_active"=>1));
            $this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('property',$data);
			$this->load->module('footer')->index($page_details);
        }

    }

    function delete_property(){
        $id=$this->input->post('id');
//        $this->mdl_general->Delete('tblproperty',array('p_id'=>$id));
		$this->mdl_general->Manage('tblproperty',array('p_active'=>0),array('p_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);

    }

	function get_property(){
		$id=$this->input->post('id');
		$info=$this->mdl_general->GetAllInfo('tblproperty','p_id',array("p_id"=>$id))[0];
		$infostr=json_encode($info);
		$val ="[".$infostr."]";
        echo $val;
    }

	function delete_photo(){
        $id=$this->input->post('id');
//        $this->mdl_general->Delete('tblproperty',array('p_id'=>$id));
		$this->mdl_general->Manage('tblphoto',array('o_del'=>1),array('o_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);

    }

    function add_new_property(){
		$form_data = array(
			'p_oid'=>$this->input->post('p_oid'),
			'p_country'=>$this->input->post('p_country'),
			'p_postcode'=>$this->input->post('p_postcode'),
			'p_propname'=>$this->input->post('p_propname'),
			'p_streetno'=>$this->input->post('p_streetno'),
			'p_streetname'=>$this->input->post('p_streetname'),
			'p_locality'=>$this->input->post('p_locality'),
			'p_town'=>$this->input->post('p_town'),
			'p_category'=>$this->input->post('p_category'),
			'p_status'=>$this->input->post('p_status'),
			'p_type'=>$this->input->post('p_type'),
			'p_beds'=>$this->input->post('p_beds'),
			'p_priceprefix'=>$this->input->post('p_priceprefix'),
			'p_price'=>$this->input->post('p_price'),
			'p_priceunit'=>$this->input->post('p_priceunit'),
			'p_area'=>$this->input->post('p_area'),
			'p_development'=>$this->input->post('p_development'),
			'p_varrange'=>$this->input->post('p_varrange'),
			'p_age'=>$this->input->post('p_age'),
			'p_tenure'=>$this->input->post('p_tenure'),
			'p_advert'=>$this->input->post('p_advert'),
			'p_parking'=>( $this->input->post('p_parking') ? '1' :'0'),
			'p_access'=>( $this->input->post('p_access') ? '1' :'0'),
			'p_garage'=>( $this->input->post('p_garage') ? '1' :'0'),
			'p_facility'=>( $this->input->post('p_facility') ? '1' :'0'),
			'p_smoke'=>( $this->input->post('p_smoke') ? '1' :'0'),
			'p_gardenos'=>( $this->input->post('p_gardenos') ? '1' :'0'),
			'p_pets'=>( $this->input->post('p_pets') ? '1' :'0'),
			'p_student'=>( $this->input->post('p_student') ? '1' :'0'),
			'p_children'=>( $this->input->post('p_children') ? '1' :'0'),
			'p_benefit'=>( $this->input->post('p_benefit') ? '1' :'0'),
			'p_vnote'=>$this->input->post('p_vnote'),
			'p_gasexpiry'=>date('Y-m-d',strtotime($this->input->post('p_gasexpiry'))),
			'p_gasissuedby'=>$this->input->post('p_gasissuedby'),
			'p_gasissueref'=>$this->input->post('p_gasissueref'),
			'p_electricexpiry'=>date('Y-m-d',strtotime($this->input->post('p_electricexpiry'))),
			'p_electricissuedby'=>$this->input->post('p_electricissuedby'),
			'p_electricissueref'=>$this->input->post('p_electricissueref'),
//			'p_hipref'=>$this->input->post('p_hipref'),
//			'p_hipurl'=>$this->input->post('p_hipurl'),
			'p_epcexpiry'=>date('Y-m-d',strtotime($this->input->post('p_epcexpiry'))),
			'p_energycur'=>$this->input->post('p_energycur'),
			'p_energypot'=>$this->input->post('p_energypot'),
			'p_envcur'=>$this->input->post('p_envcur'),
			'p_envpot'=>$this->input->post('p_envpot'),
			'p_localauth'=>$this->input->post('p_localauth'),
			'p_taxband'=>$this->input->post('p_taxband'),
			'p_manageagent'=>$this->input->post('p_manageagent'),
			'p_active'=>1,
			'p_added'=>date('Y-m-d H:i:s')
			);
        $property_id=$this->mdl_general->SaveForm('tblproperty',$form_data);
		//utility and service upload
		$categorylist =$this->mdl_general->GetAllInfoASC('dn_service_categories','id');
		foreach($categorylist as $row){
			$val=$this->input->post('p_'.$row['name']);
			$ref=$this->input->post('p_'.$row['name'].'ref');
			$this->mdl_general->SaveForm('tblpropertyservice',array('p_id'=>$property_id,'s_id'=>$val,'ref'=>$ref));
		}

		//file upload
		$propcount= count($_FILES['propImg']['name']);
		for($i=0;$i<$propcount;$i++){
			if ( !empty($_FILES['propImg']['name'][$i]) && ($_FILES['propImg']['type'][$i]=="image/gif" || $_FILES['propImg']['type'][$i]=="image/png" || $_FILES['propImg']['type'][$i]=="image/jpg"))
			{
				$filetype=substr($_FILES['propImg']['name'][$i],-4);
				$filename=substr(md5(time().$_FILES['propImg']['name'][$i]),-6).$filetype;
				move_uploaded_file($_FILES['propImg']['tmp_name'][$i],FCPATH . 'src/uploaded/'.$filename);
				$photo_data=array(
					"p_id"=>$property_id,
					"o_url" => $filename,
					"o_del" => 0
					);
				$photoid= $this->mdl_general->SaveForm('tblphoto',$photo_data);
			}
		}

		if(@$_FILES['p_hipurl']['name'] != ""){
			$config['upload_path'] = FCPATH . 'src/uploaded/';
			$config['allowed_types'] = 'jpeg|png|PNG|jpg|JPG|bmp|BMP|doc|docx|PDF';
			$config['encrypt_name'] = FALSE;
			$config['remove_spaces'] = FALSE;
			$config['max_size'] = '2048000';
			$this->upload_file($config,'p_hipurl');
			$this->mdl_general->Manage('tblproperty',array('p_hipurl' => $_FILES['p_hipurl']['name']), array('p_id' => $property_id), 'Update');
		}

		if(@$_FILES['p_epcurl']['name'] != ""){
			$config['upload_path'] = FCPATH . 'src/uploaded/';
			$config['allowed_types'] = 'jpeg|png|PNG|jpg|JPG|bmp|BMP|doc|docx|PDF';
			$config['encrypt_name'] = FALSE;
			$config['remove_spaces'] = FALSE;
			$config['max_size'] = '2048000';
			$this->upload_file($config,'p_epcurl');
			$this->mdl_general->Manage('tblproperty',array('p_epcurl' => $_FILES['p_epcurl']['name']), array('p_id' => $property_id), 'Update');
		}

		if(@$_FILES['p_planp']['name'] != ""){
			$config['upload_path'] = FCPATH . 'src/uploaded/';
			$config['allowed_types'] = 'jpeg|png|PNG|jpg|JPG|bmp|BMP';
			$config['encrypt_name'] = FALSE;
			$config['remove_spaces'] = FALSE;
			$config['max_size'] = '2048000';
			$this->upload_file($config,'p_planp');
			$this->mdl_general->Manage('tblproperty',array('p_floorplanp' => $_FILES['p_planp']['name']), array('p_id' => $property_id), 'Update');
		}

		if(@$_FILES['p_webp']['name'] != ""){
			$config['upload_path'] = FCPATH . 'src/uploaded/';
			$config['allowed_types'] = 'jpeg|png|PNG|jpg|JPG|bmp|BMP';
			$config['encrypt_name'] = FALSE;
			$config['remove_spaces'] = FALSE;
			$config['max_size'] = '2048000';
			$this->upload_file($config,'p_webp');
			$this->mdl_general->Manage('tblproperty',array('p_floorplanw' => $_FILES['p_webp']['name']), array('p_id' => $property_id), 'Update');
		}



        $response=array(
            'status'=>'success',
            'message'=>'User added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('transaction/property');


    }

    function edit_property(){
        $property_id=$this->input->post('p_id');
		$form_data = array(
			'p_oid'=>$this->input->post('p_oid'),
			'p_country'=>$this->input->post('p_country'),
			'p_postcode'=>$this->input->post('p_postcode'),
			'p_propname'=>$this->input->post('p_propname'),
			'p_streetno'=>$this->input->post('p_streetno'),
			'p_streetname'=>$this->input->post('p_streetname'),
			'p_locality'=>$this->input->post('p_locality'),
			'p_town'=>$this->input->post('p_town'),
			'p_category'=>$this->input->post('p_category'),
			'p_status'=>$this->input->post('p_status'),
			'p_type'=>$this->input->post('p_type'),
			'p_beds'=>$this->input->post('p_beds'),
			'p_priceprefix'=>$this->input->post('p_priceprefix'),
			'p_price'=>$this->input->post('p_price'),
			'p_priceunit'=>$this->input->post('p_priceunit'),
			'p_area'=>$this->input->post('p_area'),
			'p_development'=>$this->input->post('p_development'),
			'p_varrange'=>$this->input->post('p_varrange'),
			'p_age'=>$this->input->post('p_age'),
			'p_tenure'=>$this->input->post('p_tenure'),
			'p_advert'=>$this->input->post('p_advert'),
			'p_parking'=>( $this->input->post('p_parking') ? '1' :'0'),
			'p_access'=>( $this->input->post('p_access') ? '1' :'0'),
			'p_garage'=>( $this->input->post('p_garage') ? '1' :'0'),
			'p_facility'=>( $this->input->post('p_facility') ? '1' :'0'),
			'p_smoke'=>( $this->input->post('p_smoke') ? '1' :'0'),
			'p_gardenos'=>( $this->input->post('p_gardenos') ? '1' :'0'),
			'p_pets'=>( $this->input->post('p_pets') ? '1' :'0'),
			'p_student'=>( $this->input->post('p_student') ? '1' :'0'),
			'p_children'=>( $this->input->post('p_children') ? '1' :'0'),
			'p_benefit'=>( $this->input->post('p_benefit') ? '1' :'0'),
			'p_vnote'=>$this->input->post('p_vnote'),
			'p_gasexpiry'=>date('Y-m-d',strtotime($this->input->post('p_gasexpiry'))),
			'p_gasissuedby'=>$this->input->post('p_gasissuedby'),
			'p_gasissueref'=>$this->input->post('p_gasissueref'),
			'p_electricexpiry'=>date('Y-m-d',strtotime($this->input->post('p_electricexpiry'))),
			'p_electricissuedby'=>$this->input->post('p_electricissuedby'),
			'p_electricissueref'=>$this->input->post('p_electricissueref'),
			'p_epcexpiry'=>date('Y-m-d',strtotime($this->input->post('p_epcexpiry'))),
			'p_energycur'=>$this->input->post('p_energycur'),
			'p_energypot'=>$this->input->post('p_energypot'),
			'p_envcur'=>$this->input->post('p_envcur'),
			'p_envpot'=>$this->input->post('p_envpot'),
			'p_localauth'=>$this->input->post('p_localauth'),
			'p_taxband'=>$this->input->post('p_taxband'),
			'p_manageagent'=>$this->input->post('p_manageagent'),
			'p_active'=>1,
			'p_added'=>date('Y-m-d H:i:s')
			);
        $this->mdl_general->Manage('tblproperty',$form_data,array('p_id'=>$property_id));
		$o_pdef= $this->input->post('o_pdef');
		$this->mdl_general->Manage('tblphoto',array("o_default"=>0),array('p_id'=>$property_id));
		$this->mdl_general->Manage('tblphoto',array("o_default"=>1),array('o_id'=>$o_pdef));

		//utility and service upload
		$this->mdl_general->Delete('tblpropertyservice',array('p_id'=>$property_id));
		$categorylist =$this->mdl_general->GetAllInfoASC('dn_service_categories','id');
		foreach($categorylist as $row){
			$val=$this->input->post('p_'.$row['name']);
			$ref=$this->input->post('p_'.$row['name'].'ref');
			$this->mdl_general->SaveForm('tblpropertyservice',array('p_id'=>$property_id,'s_id'=>$val,'ref'=>$ref));

		}
		//file upload
		$propcount= count($_FILES['propImg']['name']);
		for($i=0;$i<$propcount;$i++){
			if ( !empty($_FILES['propImg']['name'][$i]) && ($_FILES['propImg']['type'][$i]=="image/gif" || $_FILES['propImg']['type'][$i]=="image/png" || $_FILES['propImg']['type'][$i]=="image/jpg"))
			{
				$filetype=substr($_FILES['propImg']['name'][$i],-4);
				$filename=substr(md5(time().$_FILES['propImg']['name'][$i]),-6).$filetype;
				move_uploaded_file($_FILES['propImg']['tmp_name'][$i],FCPATH . 'src/uploaded/'.$filename);
				$photo_data=array(
					"p_id"=>$property_id,
					"o_url" => $filename,
					"o_del" => 0
					);
				$photoid= $this->mdl_general->SaveForm('tblphoto',$photo_data);
			}
		}

		if(@$_FILES['p_hipurl']['name'] != ""){
			$config['upload_path'] = FCPATH . 'src/uploaded/';
			$config['allowed_types'] = 'jpeg|png|PNG|jpg|JPG|bmp|BMP|doc|docx|PDF';
			$config['encrypt_name'] = FALSE;
			$config['remove_spaces'] = FALSE;
			$config['max_size'] = '2048000';
			$this->upload_file($config,'p_hipurl');
			$this->mdl_general->Manage('tblproperty',array('p_hipurl' => $_FILES['p_hipurl']['name']), array('p_id' => $property_id), 'Update');
		}

		if(@$_FILES['p_epcurl']['name'] != ""){
			$config['upload_path'] = FCPATH . 'src/uploaded/';
			$config['allowed_types'] = 'jpeg|png|PNG|jpg|JPG|bmp|BMP|doc|docx|PDF';
			$config['encrypt_name'] = FALSE;
			$config['remove_spaces'] = FALSE;
			$config['max_size'] = '2048000';
			$this->upload_file($config,'p_epcurl');
			$this->mdl_general->Manage('tblproperty',array('p_epcurl' => $_FILES['p_epcurl']['name']), array('p_id' => $property_id), 'Update');
		}

		if(@$_FILES['p_planp']['name'] != ""){
			$config['upload_path'] = FCPATH . 'src/uploaded/';
			$config['allowed_types'] = 'jpeg|png|PNG|jpg|JPG|bmp|BMP';
			$config['encrypt_name'] = FALSE;
			$config['remove_spaces'] = FALSE;
			$config['max_size'] = '2048000';
			$this->upload_file($config,'p_planp');
			$this->mdl_general->Manage('tblproperty',array('p_floorplanp' => $_FILES['p_planp']['name']), array('p_id' => $property_id), 'Update');
		}

		if(@$_FILES['p_webp']['name'] != ""){
			$config['upload_path'] = FCPATH . 'src/uploaded/';
			$config['allowed_types'] = 'jpeg|png|PNG|jpg|JPG|bmp|BMP';
			$config['encrypt_name'] = FALSE;
			$config['remove_spaces'] = FALSE;
			$config['max_size'] = '2048000';
			$this->upload_file($config,'p_webp');
			$this->mdl_general->Manage('tblproperty',array('p_floorplanw' => $_FILES['p_webp']['name']), array('p_id' => $property_id), 'Update');
		}



        $response=array(
            'status'=>'success',
            'message'=>'User added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('transaction/property');
    }


//---------------------------------------Landlord---------------------------------------//
	function landlord($type=null,$id=null){

        if($type=='add'){
            $page_details['page_title']="ONYX TECH | Landlord Registration";
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('landlord_add');

        }elseif($type=='edit' && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Landlord Registration";
            $data['contact_data']=$this->mdl_general->GetInfoByRow('tbllandlord','c_id',array('c_id'=>$id));
			$data['account_data']=$this->mdl_general->GetAllInfo('tblaccount','a_id',array('a_landlordid'=>$id));
			$data['property_list']=$this->mdl_general->GetAllInfo('tblproperty','p_id',array("p_active"=>1,"p_oid"=>$id));
			$data['document_list']=$this->mdl_general->GetAllInfo('tbldocument','d_id',array("d_otype"=>1,"d_oid"=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('landlord_edit',$data);

        }else{
			$page_details['page_title']="ONYX TECH | Landlord List";
			$data['contact_list']=$this->mdl_general->GetAllInfo('tbllandlord','c_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('landlord',$data);
			$this->load->module('footer')->index($page_details);

        }


    }

    function add_landlord(){
        $contact_data=array(
            'c_namef'=>$this->input->post('c_namef'),
            'c_namel'=>$this->input->post('c_namel'),
            'c_title'=>$this->input->post('c_title'),
            'c_birth'=>date('Y-m-d',strtotime($this->input->post('c_birth'))),
            'c_address1'=>$this->input->post('c_address1'),
            'c_email'=>$this->input->post('c_email'),
			'c_address2'=>$this->input->post('c_address2'),
			'c_companyname'=>$this->input->post('c_companyname'),
            'c_phone'=>$this->input->post('c_phone'),
            'c_mobile1'=>$this->input->post('c_mobile1'),
            'c_mobile1ref'=>$this->input->post('c_mobile1ref'),
			'c_mobile2'=>$this->input->post('c_mobile2'),
            'c_mobile2ref'=>$this->input->post('c_mobile2ref'),
			'c_sms'=>$this->input->post('c_sms'),
            'c_vatf'=>$this->input->post('c_vatf'),
			'c_regno'=>$this->input->post('c_regno'),
			'c_vatregdate'=>date('Y-m-d',strtotime($this->input->post('c_vatregdate'))),
            'c_vatregno'=>$this->input->post('c_vatregno'),
            'c_commission'=>$this->input->post('c_commission'),
			'c_expdate'=>date('Y-m-d',strtotime($this->input->post('c_expdate'))),
			'c_authority'=>$this->input->post('c_authority'),
			'c_fee'=>$this->input->post('c_fee'),
			'c_threshold'=>$this->input->post('c_threshold'),
			'c_country'=>$this->input->post('c_country'),
			'c_postcode'=>$this->input->post('c_postcode'),
			'c_city'=>$this->input->post('c_city'),
			'c_sacof'=>$this->input->post('c_sacof'),
			'c_nonres'=>$this->input->post('c_nonres'),
			'c_nonres_applyfrom'=>date('Y-m-d',strtotime($this->input->post('c_nonres_applyfrom'))),
			'c_nonres_zerotax'=>$this->input->post('c_nonres_zerotax'),
			'c_nonres_ref'=>$this->input->post('c_nonres_ref'),
			'c_nonres_date'=>date('Y-m-d',strtotime($this->input->post('c_nonres_date'))),
			'c_retainvat'=>$this->input->post('c_retainvat'),
			'c_carealert'=>$this->input->post('c_carealert'),
			'c_privatenote'=>$this->input->post('c_privatenote'),
			'c_ic'=>$this->input->post('c_ic')
        );

        $tblcontact=$this->mdl_general->SaveForm('tbllandlord',$contact_data);
        $response=array(
            'status'=>'success',
            'message'=>'Contact added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('transaction/landlord');

    }

    function edit_landlorddetail(){
        $c_id=$this->input->post('hdnContactId');
		$active= $this->input->post('c_active');
        $contact_data=array(
            'c_namef'=>$this->input->post('c_namef'),
            'c_namel'=>$this->input->post('c_namel'),
            'c_title'=>$this->input->post('c_title'),
            'c_birth'=>date('Y-m-d',strtotime($this->input->post('c_birth'))),
            'c_address1'=>$this->input->post('c_address1'),
            'c_email'=>$this->input->post('c_email'),
			'c_address2'=>$this->input->post('c_address2'),
			'c_companyname'=>$this->input->post('c_companyname'),
            'c_phone'=>$this->input->post('c_phone'),
            'c_mobile1'=>$this->input->post('c_mobile1'),
            'c_mobile1ref'=>$this->input->post('c_mobile1ref'),
			'c_mobile2'=>$this->input->post('c_mobile2'),
            'c_mobile2ref'=>$this->input->post('c_mobile2ref'),
			'c_sms'=>$this->input->post('c_sms'),
            'c_vatf'=>$this->input->post('c_vatf'),
			'c_vatregdate'=>date('Y-m-d',strtotime($this->input->post('c_vatregdate'))),
            'c_vatregno'=>$this->input->post('c_vatregno'),
            'c_commission'=>$this->input->post('c_commission'),
			'c_expdate'=>date('Y-m-d',strtotime($this->input->post('c_expdate'))),
			'c_authority'=>$this->input->post('c_authority'),
			'c_regno'=>$this->input->post('c_regno'),
			'c_fee'=>$this->input->post('c_fee'),
			'c_threshold'=>$this->input->post('c_threshold'),
			'c_country'=>$this->input->post('c_country'),
			'c_postcode'=>$this->input->post('c_postcode'),
			'c_city'=>$this->input->post('c_city'),
			'c_sacof'=>$this->input->post('c_sacof'),
			'c_nonres'=>$this->input->post('c_nonres'),
			'c_nonres_applyfrom'=>date('Y-m-d',strtotime($this->input->post('c_nonres_applyfrom'))),
			'c_nonres_zerotax'=>$this->input->post('c_nonres_zerotax'),
			'c_nonres_ref'=>$this->input->post('c_nonres_ref'),
			'c_nonres_date'=>date('Y-m-d',strtotime($this->input->post('c_nonres_date'))),
			'c_retainvat'=>$this->input->post('c_retainvat'),
			'c_carealert'=>$this->input->post('c_carealert'),
			'c_privatenote'=>$this->input->post('c_privatenote'),
			'c_ic'=>$this->input->post('c_ic'),
			'c_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->Manage('tbllandlord',$contact_data,array('c_id'=>$c_id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'Contact updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('transaction/landlord');
    }

    function delete_landlord(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('tbllandlord',array('c_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

	 function delete_account(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('tblaccount',array('a_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

	function add_account(){
        $contact_data=array(
            'a_bankname'=>$this->input->post('a_bankname'),
			'a_accountname'=>$this->input->post('a_accountname'),
			'a_accountno'=>$this->input->post('a_accountno'),
			'a_sortcode'=>$this->input->post('a_sortcode'),
			'a_landlordid'=>$this->input->post('a_landlordid')
        );
		$pageid=$this->input->post('pageid');
        $tblcontact=$this->mdl_general->SaveForm('tblaccount',$contact_data);
        $response=array(
            'status'=>'success',
            'message'=>'Contact added successfully'
            );
        $this->session->set_flashdata($response);
		if(!empty($pageid))
			redirect('transaction/landlord/edit/'.$pageid);
        redirect('transaction/account');

    }

	function edit_account(){
        $contact_data=array(
            'a_bankname'=>$this->input->post('a_bankname'),
			'a_accountname'=>$this->input->post('a_accountname'),
			'a_accountno'=>$this->input->post('a_accountno'),
			'a_sortcode'=>$this->input->post('a_sortcode'),
			'a_landlordid'=>$this->input->post('a_landlordid')
        );
		$id=$this->input->post('id');
        $tblcontact=$this->mdl_general->Manage('tblaccount',$contact_data,array('a_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'account added successfully'
            );
        echo json_encode($response);
    }
	function add_document(){

        $contact_data=array(
            'd_desc'=>$this->input->post('a_bankname'),
			'd_oid'=>$this->input->post('a_accountname'),
			'd_otype'=>$this->input->post('a_accountno'),
			'd_date'=>date("Y-m-d")
        );
		if(!empty($_FILES['d_file']['tmp_name']))
		{
			$filetype=substr($_FILES['d_file']['name'],-4);
			$filename=substr(md5(time().$_FILES['d_file']['name']),-6).$filetype;
			move_uploaded_file($_FILES['d_file']['tmp_name'],FCPATH . 'src/uploaded/'.$filename);
			$contact_data=array(
				'd_desc'=>$this->input->post('d_desc'),
				'd_oid'=>$this->input->post('d_oid'),
				'd_otype'=>$this->input->post('d_otype'),
				'd_date'=>date("Y-m-d"),
				'd_name'=>$filename
			);
			$tblcontact=$this->mdl_general->SaveForm('tbldocument',$contact_data);

		}
        $response=array(
            'status'=>'success',
            'message'=>'account added successfully'
            );
		redirect('transaction/landlord/edit/'.$this->input->post('d_oid'));
    }


	//---------------------------------------tenant---------------------------------------//
	function tenant($type=null,$id=null){

        if($type=='add' && is_null($id)){
            $page_details['page_title']="ONYX TECH | Tenant Registration";
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('tenant_add');
		}else if($type=='add' && !is_null($id)){
			$page_details['page_title']="ONYX TECH | Tenant Registration";
			$data['enq_data']=$this->mdl_general->GetInfoByRow('tblenquiry','e_id',array('e_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('tenant_addenq',$data);

        }elseif($type=='edit' && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Tenant Registration";
            $data['contact_data']=$this->mdl_general->GetInfoByRow('tbltenant','c_id',array('c_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('tenant_edit',$data);

        }else{
            $page_details['page_title']="ONYX TECH | Tenant list";
			$data['contact_list']=$this->mdl_general->GetAllInfo('tbltenant','c_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('tenant',$data);
			$this->load->module('footer')->index($page_details);
        }


    }

    function add_tenant(){
        $contact_data=array(
            'c_namef'=>$this->input->post('c_namef'),
            'c_namel'=>$this->input->post('c_namel'),
			'c_namem'=>$this->input->post('c_namem'),
            'c_title'=>$this->input->post('c_title'),
            'c_birth'=>date('Y-m-d',strtotime($this->input->post('c_birth'))),
            'c_address1'=>$this->input->post('c_address1'),
			'c_address2'=>$this->input->post('c_address2'),
			'c_city'=>$this->input->post('c_city'),
			'c_country'=>$this->input->post('c_country'),
			'c_postcode'=>$this->input->post('c_postcode'),
			'c_companyname'=>$this->input->post('c_companyname'),
            'c_phone'=>$this->input->post('c_phone'),
            'c_mobile1'=>$this->input->post('c_mobile1'),
            'c_mobile1ref'=>$this->input->post('c_mobile1ref'),
			'c_mobile2'=>$this->input->post('c_mobile2'),
            'c_mobile2ref'=>$this->input->post('c_mobile2ref'),
			'c_sms'=>$this->input->post('c_sms'),
			'c_regdate'=>date('Y-m-d',strtotime($this->input->post('c_regdate'))),
			'c_sacof'=>$this->input->post('c_sacof'),
			'c_country'=>$this->input->post('c_country'),
			'c_nation'=>$this->input->post('c_country'),
			'c_email'=>$this->input->post('c_email'),
            'c_ssn'=>$this->input->post('c_ssn'),
			'c_secaddress1'=>$this->input->post('c_secaddress1'),
			'c_secaddress2'=>$this->input->post('c_secaddress2'),
			'c_seccity'=>$this->input->post('c_seccity'),
			'c_seccountry'=>$this->input->post('c_seccountry'),
			'c_secpostcode'=>$this->input->post('c_secpostcode'),
			'c_resstatus'=>$this->input->post('c_resstatus'),
			'c_taca'=>$this->input->post('c_taca'),
			'c_gender'=>$this->input->post('c_gender'),
			'c_marstatus'=>$this->input->post('c_marstatus'),
			'c_empstatus'=>$this->input->post('c_empstatus'),
			'c_jobtitle'=>$this->input->post('c_jobtitle'),
			'c_annualincome'=>$this->input->post('c_annualincome'),
			'c_tacj'=>$this->input->post('c_tacj'),
			'c_employer'=>$this->input->post('c_employer'),
			'c_empaddress1'=>$this->input->post('c_empaddress1'),
			'c_empaddress2'=>$this->input->post('c_empaddress2'),
			'c_emptown'=>$this->input->post('c_emptown'),
			'c_empcountry'=>$this->input->post('c_empcountry'),
			'c_emppostcode'=>$this->input->post('c_emppostcode'),
			'c_carealert'=>$this->input->post('c_carealert'),
			'c_privatenote'=>$this->input->post('c_privatenote'),
			'c_ic'=>$this->input->post('c_ic')
        );
        $tblcontact=$this->mdl_general->SaveForm('tbltenant',$contact_data);
        $response=array(
            'status'=>'success',
            'message'=>'Contact added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('transaction/tenant');

    }

    function edit_tenant(){
        $c_id=$this->input->post('hdnContactId');
        $contact_data=array(
            'c_namef'=>$this->input->post('c_namef'),
            'c_namel'=>$this->input->post('c_namel'),
			'c_namem'=>$this->input->post('c_namem'),
            'c_title'=>$this->input->post('c_title'),
            'c_birth'=>date('Y-m-d',strtotime($this->input->post('c_birth'))),
            'c_address1'=>$this->input->post('c_address1'),
			'c_address2'=>$this->input->post('c_address2'),
			'c_city'=>$this->input->post('c_city'),
			'c_country'=>$this->input->post('c_country'),
			'c_postcode'=>$this->input->post('c_postcode'),
			'c_companyname'=>$this->input->post('c_companyname'),
            'c_phone'=>$this->input->post('c_phone'),
            'c_mobile1'=>$this->input->post('c_mobile1'),
            'c_mobile1ref'=>$this->input->post('c_mobile1ref'),
			'c_mobile2'=>$this->input->post('c_mobile2'),
            'c_mobile2ref'=>$this->input->post('c_mobile2ref'),
			'c_sms'=>$this->input->post('c_sms'),
			'c_regdate'=>date('Y-m-d',strtotime($this->input->post('c_regdate'))),
			'c_sacof'=>$this->input->post('c_sacof'),
			'c_country'=>$this->input->post('c_country'),
			'c_nation'=>$this->input->post('c_country'),
			'c_email'=>$this->input->post('c_email'),
            'c_ssn'=>$this->input->post('c_ssn'),
			'c_secaddress1'=>$this->input->post('c_secaddress1'),
			'c_secaddress2'=>$this->input->post('c_secaddress2'),
			'c_seccity'=>$this->input->post('c_seccity'),
			'c_seccountry'=>$this->input->post('c_seccountry'),
			'c_secpostcode'=>$this->input->post('c_secpostcode'),
			'c_resstatus'=>$this->input->post('c_resstatus'),
			'c_taca'=>$this->input->post('c_taca'),
			'c_gender'=>$this->input->post('c_gender'),
			'c_marstatus'=>$this->input->post('c_marstatus'),
			'c_empstatus'=>$this->input->post('c_empstatus'),
			'c_jobtitle'=>$this->input->post('c_jobtitle'),
			'c_annualincome'=>$this->input->post('c_annualincome'),
			'c_tacj'=>$this->input->post('c_tacj'),
			'c_employer'=>$this->input->post('c_employer'),
			'c_empaddress1'=>$this->input->post('c_empaddress1'),
			'c_empaddress2'=>$this->input->post('c_empaddress2'),
			'c_emptown'=>$this->input->post('c_emptown'),
			'c_empcountry'=>$this->input->post('c_empcountry'),
			'c_emppostcode'=>$this->input->post('c_emppostcode'),
			'c_carealert'=>$this->input->post('c_carealert'),
			'c_privatenote'=>$this->input->post('c_privatenote'),
			'c_ic'=>$this->input->post('c_ic')
        );
        $this->mdl_general->Manage('tbltenant',$contact_data,array('c_id'=>$c_id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'Contact updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('transaction/tenant');
    }

	function get_tenant(){
		$id=$this->input->post('id');
		$info=$this->mdl_general->GetAllInfo('tbltenant','c_id',array("c_id"=>$id))[0];
		$infostr=json_encode($info);
		$val ="[".$infostr."]";
        echo $val;
    }

    function delete_tenant(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('tbltenant',array('c_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

//agent
function agent($type=null,$id=null){

        if($type=='add'){
            $page_details['page_title']="ONYX TECH | Agent Registration";
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('agent_add');

        }elseif($type=='edit' && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Agent Registration";
            $data['contact_data']=$this->mdl_general->GetInfoByRow('tblagent','a_id',array('a_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('agent_edit',$data);

        }else{
			$page_details['page_title']="ONYX TECH | Agent List";
			$data['contact_list']=$this->mdl_general->GetAllInfo('tblagent','a_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('agent',$data);
			$this->load->module('footer')->index($page_details);

        }


    }

    function add_agent(){
        $contact_data=array(
            'a_namef'=>$this->input->post('a_namef'),
            'a_namel'=>$this->input->post('a_namel'),
            'a_title'=>$this->input->post('a_title'),
            'a_address1'=>$this->input->post('a_address1'),
            'a_email'=>$this->input->post('a_email'),
			'a_address2'=>$this->input->post('a_address2'),
			'a_companyname'=>$this->input->post('a_companyname'),
            'a_phone'=>$this->input->post('a_phone'),
			'a_website'=>$this->input->post('a_website'),
            'a_remarks'=>$this->input->post('a_remarks'),
			'a_comm'=>$this->input->post('a_comm'),
			'a_country'=>$this->input->post('a_country'),
			'a_postcode'=>$this->input->post('a_postcode'),
			'a_city'=>$this->input->post('a_city'),
			'a_area'=>$this->input->post('a_area'),
			'a_ic'=>$this->input->post('a_ic')
        );

        $tblcontact=$this->mdl_general->SaveForm('tblagent',$contact_data);
        $response=array(
            'status'=>'success',
            'message'=>'Agent added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('transaction/agent');

    }

    function edit_agent(){
        $a_id=$this->input->post('a_id');
		//$active= $this->input->post('a_active');
        $contact_data=array(
            'a_namef'=>$this->input->post('a_namef'),
            'a_namel'=>$this->input->post('a_namel'),
            'a_title'=>$this->input->post('a_title'),
            'a_address1'=>$this->input->post('a_address1'),
            'a_email'=>$this->input->post('a_email'),
			'a_address2'=>$this->input->post('a_address2'),
			'a_companyname'=>$this->input->post('a_companyname'),
            'a_phone'=>$this->input->post('a_phone'),
			'a_website'=>$this->input->post('a_website'),
            'a_remarks'=>$this->input->post('a_remarks'),
			'a_comm'=>$this->input->post('a_comm'),
			'a_country'=>$this->input->post('a_country'),
			'a_postcode'=>$this->input->post('a_postcode'),
			'a_city'=>$this->input->post('a_city'),
			'a_area'=>$this->input->post('a_area'),
			'a_ic'=>$this->input->post('a_ic')
//			'a_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->Manage('tblagent',$contact_data,array('a_id'=>$a_id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'Agent updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('transaction/agent');
    }

    function delete_agent(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('tblagent',array('a_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }
//send email form

	function sendEmailForm(){

		$attaches=array();
		$propcount= count($_FILES['e_attach']['name'])-1;
		for($i=0;$i<$propcount;$i++){
			if ( !empty($_FILES['e_attach']['name'][$i]) && ($_FILES['e_attach']['type'][$i]=="image/gif" || $_FILES['e_attach']['type'][$i]=="image/png" || $_FILES['e_attach']['type'][$i]=="image/jpg"))
			{
				$filename=$_FILES['e_attach']['name'][$i];
				move_uploaded_file($_FILES['e_attach']['tmp_name'][$i],FCPATH . 'src/tmp/'.$filename);
				$attaches[]=$filename;
			}
		}
		$sender=$this->mdl_general->GetInfoByRow('acs_configration','config_id',array('config_id'=>"1"));
        $this->load->library('email');
        $subject=$this->input->post('e_subject');
		$message=$this->input->post('e_message');
		$direct=$this->input->post('e_direct');
		$receiver=$this->input->post('emailto');
		$config['useragent']  = "CodeIgniter";
		$config['mailpath']  = "/usr/sbin/sendmail"; // or "/usr/sbin/sendmail"
		$config['protocol']   = "sendmail";
		$config['mailtype'] = 'html';
		$config['charset']  = 'utf-8';
		$config['newline']  = "\r\n";
		$config['wordwrap'] = TRUE;
		$config['validate']=TRUE;
		$this->email->initialize($config);
		$this->email->from($sender->emailsenderaddress,$sender->emailsendername);
		$this->email->to($receiver);
		$this->email->subject($subject);
		$this->email->message($message);
		if($propcount>0){
			for($i=0;$i<$propcount;$i++){
				$this->email->attach(FCPATH.'src/tmp/'.$attaches[$i]);
			}
		}

		if($this->email->send()){
			$deliveryStatus.="Email has been sent to:".$to."<br />";
		}else{
			$deliveryStatus.="Email sending failed to:".$to."<br />";
		}

		$this->email->clear();

        $this->session->set_flashdata('email_status',$deliveryStatus);
        redirect('transaction/'.$direct);
     }
//send mail form for SMS
	function sendMailForm(){
		$message=$this->input->post('e_message');
		$direct=$this->input->post('direct');
		$receiver=$this->input->post('mailto');
		$url = "http://www.voodoosms.com/vapi/server/sendSMS?";
		 //Post variable names should be same as mentioned below example and its case sensitive as well
		$message=urlencode($message);
		$url .='dest=44'.$receiver;
		$url .='&orig=Ucare';
		$url .='&msg='.$message;
		$url .='&uid=pms';
		$url .='&pass=wfcsuj6';
		$url .='&validity=1';
		$url .='&format=php';

		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$response = curl_exec($ch);
		curl_close($ch);
		$delivered_sms="SMS has been sent. <br />";

		$this->session->set_flashdata('sms_status',$delivered_sms);
		redirect('transaction/'.$direct);
    }
//enquiry

function enquiry($type=null,$id=null){

        if($type=='add'){
            $page_details['page_title']="ONYX TECH | Enquiry Registration";
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('enquiry_add');

        }elseif($type=='edit' && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Enquiry Registration";
            $data['contact_data']=$this->mdl_general->GetInfoByRow('tblenquiry','e_id',array('e_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('enquiry_edit',$data);

        }else{
			$page_details['page_title']="ONYX TECH | Enquiry List";
			$data['contact_list']=$this->mdl_general->GetAllInfo('tblenquiry','e_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('enquiry',$data);
			$this->load->module('footer')->index($page_details);

        }


    }

    function add_enquiry(){
		$active= $this->input->post('e_active');
		$areas=$this->input->post("e_areavalues");
        $contact_data=array(
            'e_namef'=>$this->input->post('e_namef'),
            'e_namel'=>$this->input->post('e_namel'),
            'e_title'=>$this->input->post('e_title'),
			'e_postcode'=>$this->input->post('e_postcode'),
            'e_address'=>$this->input->post('e_address'),
			'e_city'=>$this->input->post('e_city'),
            'e_email'=>$this->input->post('e_email'),
			'e_country'=>$this->input->post('e_country'),
            'e_phone1'=>$this->input->post('e_mobile1'),
            'e_desc1'=>$this->input->post('e_mobile1ref'),
			'e_phone2'=>$this->input->post('e_mobile2'),
            'e_desc2'=>$this->input->post('e_mobile2ref'),
			'e_phone3'=>$this->input->post('e_mobile3'),
            'e_desc3'=>$this->input->post('e_mobile3ref'),
			'e_vreq'=>$this->input->post('e_vreq'),
			'e_dreq'=>$this->input->post('e_dreq'),
			'e_greq'=>$this->input->post('e_greq'),
            'e_comments'=>$this->input->post('e_comments'),
			'e_ref1title'=>$this->input->post('e_ref1title'),
			'e_ref1namef'=>$this->input->post('e_ref1namef'),
            'e_ref1namel'=>$this->input->post('e_ref1namel'),
			'e_ref1postcode'=>$this->input->post('e_ref1postcode'),
            'e_ref1address'=>$this->input->post('e_ref1address'),
            'e_ref1email'=>$this->input->post('e_ref1email'),
			'e_ref1city'=>$this->input->post('e_ref1city'),
			'e_ref1country'=>$this->input->post('e_ref1country'),
            'e_ref1phone'=>$this->input->post('e_ref1phone'),
			'e_ref1relation'=>$this->input->post('e_ref1relation'),
			'e_ref1nyk'=>$this->input->post('e_ref1nyk'),
			'e_ref1remarks'=>$this->input->post('e_ref1remarks'),
			'e_ref2title'=>$this->input->post('e_ref2title'),
			'e_ref2namef'=>$this->input->post('e_ref2namef'),
            'e_ref2namel'=>$this->input->post('e_ref2namel'),
			'e_ref2postcode'=>$this->input->post('e_ref2postcode'),
            'e_ref2address'=>$this->input->post('e_ref2address'),
			'e_ref2city'=>$this->input->post('e_ref2city'),
            'e_ref2email'=>$this->input->post('e_ref2email'),
			'e_ref2country'=>$this->input->post('e_ref2country'),
            'e_ref2phone'=>$this->input->post('e_ref2phone'),
			'e_ref2relation'=>$this->input->post('e_ref2relation'),
			'e_ref2nyk'=>$this->input->post('e_ref2nyk'),
			'e_ref2remarks'=>$this->input->post('e_ref2remarks'),
			'e_added'=>date('Y-m-d H:i:s'),
			'e_dates'=>date('Y-m-d',strtotime($this->input->post('e_dates'))),
			'e_days'=>$this->input->post('e_days'),
			'e_proptype'=>$this->input->post('e_proptype'),
			'e_ref1status'=>$this->input->post('e_ref1status'),
			'e_ref2status'=>$this->input->post('e_ref2status'),
			'e_maxrent'=>$this->input->post('e_maxrent'),
			'e_active'=>( $active ? $active :'0')
        );
        $tblcontact=$this->mdl_general->SaveForm('tblenquiry',$contact_data);
		$a_area= explode(",",$areas);
		for($i=0;$i<count($a_area);$i++){
			$this->mdl_general->SaveForm('tblenqarea',array('e_id'=>$tblcontact,'a_id'=>$a_area[$i]));
		}
        $response=array(
            'status'=>'success',
            'message'=>'Contact added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('transaction/enquiry');

    }

    function edit_enquiry(){
        $e_id=$this->input->post('e_id');
		$active= $this->input->post('e_active');
        $contact_data=array(
            'e_namef'=>$this->input->post('e_namef'),
            'e_namel'=>$this->input->post('e_namel'),
            'e_title'=>$this->input->post('e_title'),
			'e_postcode'=>$this->input->post('e_postcode'),
            'e_address'=>$this->input->post('e_address'),
            'e_email'=>$this->input->post('e_email'),
			'e_city'=>$this->input->post('e_city'),
			'e_country'=>$this->input->post('e_country'),
            'e_phone1'=>$this->input->post('e_mobile1'),
            'e_desc1'=>$this->input->post('e_mobile1ref'),
			'e_phone2'=>$this->input->post('e_mobile2'),
            'e_desc2'=>$this->input->post('e_mobile2ref'),
			'e_phone3'=>$this->input->post('e_mobile3'),
            'e_desc3'=>$this->input->post('e_mobile3ref'),
			'e_vreq'=>$this->input->post('e_vreq'),
			'e_dreq'=>$this->input->post('e_dreq'),
			'e_greq'=>$this->input->post('e_greq'),
            'e_comments'=>$this->input->post('e_comments'),
			'e_ref1title'=>$this->input->post('e_ref1title'),
			'e_ref1namef'=>$this->input->post('e_ref1namef'),
            'e_ref1namel'=>$this->input->post('e_ref1namel'),
			'e_ref1city'=>$this->input->post('e_ref1city'),
			'e_ref1postcode'=>$this->input->post('e_ref1postcode'),
            'e_ref1address'=>$this->input->post('e_ref1address'),
            'e_ref1email'=>$this->input->post('e_ref1email'),
			'e_ref1country'=>$this->input->post('e_ref1country'),
            'e_ref1phone'=>$this->input->post('e_ref1phone'),
			'e_ref1relation'=>$this->input->post('e_ref1relation'),
			'e_ref1nyk'=>$this->input->post('e_ref1nyk'),
			'e_ref1remarks'=>$this->input->post('e_ref1remarks'),
			'e_ref2title'=>$this->input->post('e_ref2title'),
			'e_ref2namef'=>$this->input->post('e_ref2namef'),
            'e_ref2namel'=>$this->input->post('e_ref2namel'),
			'e_ref2postcode'=>$this->input->post('e_ref2postcode'),
            'e_ref2address'=>$this->input->post('e_ref2address'),
			'e_ref2city'=>$this->input->post('e_ref2city'),
            'e_ref2email'=>$this->input->post('e_ref2email'),
			'e_ref2country'=>$this->input->post('e_ref2country'),
            'e_ref2phone'=>$this->input->post('e_ref2phone'),
			'e_ref2relation'=>$this->input->post('e_ref2relation'),
			'e_ref2nyk'=>$this->input->post('e_ref2nyk'),
			'e_ref2remarks'=>$this->input->post('e_ref2remarks'),
			'e_proptype'=>$this->input->post('e_proptype'),
			'e_added'=>date('Y-m-d H:i:s'),
			'e_dates'=>date('Y-m-d',strtotime($this->input->post('e_dates'))),
			'e_days'=>$this->input->post('e_days'),
			'e_ref1status'=>$this->input->post('e_ref1status'),
			'e_ref2status'=>$this->input->post('e_ref2status'),
			'e_maxrent'=>$this->input->post('e_maxrent'),
			'e_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->Manage('tblenquiry',$contact_data,array('e_id'=>$e_id),'Update');
		$this->mdl_general->Delete('tblenqarea',array('e_id'=>$e_id));
		$areas=$this->input->post("e_areavalues");
		$a_area= explode(",",$areas);
		for($i=0;$i<count($a_area);$i++){
			if($a_area[$i] == 0)
				continue;
			$this->mdl_general->SaveForm('tblenqarea',array('e_id'=>$e_id,'a_id'=>$a_area[$i]));
		}
        $response=array(
            'status'=>'success',
            'message'=>'Contact updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('transaction/enquiry');
    }
/*
	function enquirytotenant($e_id){

		$enquiry=$this->mdl_general->GetAllInfo('tblenquiry','e_id',array('e_id'=>$e_id))[0];

		$contact_data=array(
            'c_namef'=>$enquiry['e_namef'],
            'c_namel'=>$enquiry['e_namel'],
			'c_namem'=>" ",
            'c_title'=>$enquiry['e_title'],
            'c_address1'=>$enquiry['e_address'],
			'c_city'=>$enquiry['e_city'],
			'c_email'=>$enquiry['e_email'],
			'c_country'=>$enquiry['e_country'],
			'c_postcode'=>$enquiry['e_postcode'],
            'c_phone'=>$enquiry['e_phone1'],
            'c_mobile1'=>$enquiry['e_phone2'],
            'c_mobile1ref'=>$enquiry['e_desc2'],
			'c_mobile2'=>$enquiry['e_phone3'],
            'c_mobile2ref'=>$enquiry['e_desc3'],
			'c_regdate'=>date('Y-m-d'),
			'c_ic'=>0
        );
        $tblcontact=$this->mdl_general->SaveForm('tbltenant',$contact_data);
		$this->mdl_general->Manage('tblenquiry',array('e_convert'=>1),array('e_id'=>$e_id),'Update');

        $response=array(
            'status'=>'success',
            'message'=>'Contact updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('transaction/enquiry');
    }
*/
    function delete_enquiry(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('tblenquiry',array('e_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

	function get_area(){
		$id=$this->input->post('id');
		$info=$this->mdl_general->GetAllInfo('tblarea','a_id',array("a_city"=>$id,"a_active"=>1));
		$infostr=json_encode($info);
        echo $infostr;
    }

	function enqres($id=null){
		$where = array("p_active"=>1);
		$areas=array();
		if(!empty($id)){
			$enq= $this->mdl_general->GetInfoByRow('tblenquiry','e_id',array('e_id'=>$id));
			//get area
			$areas=$this->mdl_general->GetAllInfo('tblenqarea','a_id',array('e_id'=>$id));
			//get property type
			$prop=$enq->e_proptype;
			if($prop !=0){
				$where["p_type"]=$prop;
			}
		}
		$page_details['page_title']="ONYX TECH | Properties";
		$res=$this->mdl_general->GetAllInfo('tblproperty','p_id',$where);
		$data['property_list']=array();
		if(count($res)>0 && count($areas)>0){
			foreach ($res as $row){
				foreach($areas as $val){
					if($row['p_area'] == $val['a_id']){
						$data['property_list'][]=$row;
						continue;
					}
				}
			}
		} else {
			$data['property_list']=$this->mdl_general->GetAllInfo('tblproperty','p_id',$where);
		}
		//$data['property_list']=$this->mdl_general->GetAllInfo('tblproperty','p_id',$where);
		$this->load->module('header')->index($page_details);
		$this->load->module('sidebar')->index($page_details);
		$this->load->view('enqres',$data);
		$this->load->module('footer')->index($page_details);
	}
//tenantcontract
	function tenantcontract($type=null,$id=null){

        if($type=='add'){
            $page_details['page_title']="ONYX TECH | Tenant Rent Contract Registration";
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('tenantcontract_add');
        }elseif($type=='edit' && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Tenant Rent Contract Edit";
            $data['contract_data']=$this->mdl_general->GetInfoByRow('tblcontract','rc_id',array('rc_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('tenantcontract_edit',$data);
		}elseif($type=='doc' && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Tenant Rent Contract Document";
            $data['contract_data']=$this->mdl_general->GetInfoByRow('tblcontract','rc_id',array('rc_id'=>$id));
			$list =$this->mdl_general->GetAllInfo('tblattachletter','al_id',array('cl_id'=>$data['contract_data']->rc_document));
			$templates=array();
			foreach($list as $row){
				$template=$this->mdl_general->GetAllInfo('dn_lettertemplate','lt_id',array('lt_id'=>$row['lt_id']));
				if(count($template)>0)
					$templates=array_merge($templates,$template);
			}
			$data['templates']=$templates;
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('tenantcontract_doc',$data);
        }else{
            $page_details['page_title']="ONYX TECH | Tenant Rent Contract list";
			$data['tenantcontract_list']=$this->mdl_general->GetAllInfo('tblcontract','rc_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('tenantcontract',$data);
			$this->load->module('footer')->index($page_details);
        }
    }

	function getreminder(){
		$id=$this->input->post('id');
		$res=$this->mdl_general->getAllInfo('tblreminder','r_id',array('rc_id'=>$id));
		echo json_encode($res);
	}

	function getfees(){
		$id=$this->input->post('id');
		$res=$this->mdl_general->getAllInfo('tblfee','f_id',array('f_cid'=>$id));
		echo json_encode($res);
	}

    function add_tenantcontract(){
		$contract_data=array(
			"rc_date" =>date('Y-m-d',strtotime($this->input->post('rc_date'))),
			'rc_status'=>$this->input->post('rc_status'),
			'rc_document'=>$this->input->post('rc_document'),
			"rc_fromdate" =>date('Y-m-d',strtotime($this->input->post('rc_fromdate'))),
			"rc_todate" =>date('Y-m-d',strtotime($this->input->post('rc_todate'))),
			'rc_rent'=>$this->input->post('rc_rent'),
			'rc_unit'=>$this->input->post('rc_unit'),
			'rc_paymentmode'=>$this->input->post('rc_paymentmode'),
			'rc_bankname'=>$this->input->post('rc_bankname'),
			'rc_sortcode'=>$this->input->post('rc_sortcode'),
			'rc_accountno'=>$this->input->post('rc_accountno'),
			'rc_instruction'=>$this->input->post('rc_instruction'),
			"rc_rentpaydate" =>date('Y-m-d',strtotime($this->input->post('rc_rentpaydate'))),
			'rc_gracedays'=>$this->input->post('rc_gracedays'),
			'rc_surcharge'=>$this->input->post('rc_surcharge'),
			'rc_deposit'=>$this->input->post('rc_deposit'),
			'rc_surunit'=>$this->input->post('rc_surunit'),
//			'rc_reminder'=>$this->input->post('rc_reminder'),
			'rc_remindermode'=>$this->input->post('rc_remindermode'),
//			'rc_reminderdatetime'=>date('Y-m-d H:i:s',strtotime($this->input->post('rc_reminderdatetime'))),
//			'rc_reminderlettertemplate'=>$this->input->post('rc_reminderlettertemplate'),
			'p_id'=>$this->input->post('p_id'),
			't_id'=>$this->input->post('c_id'),
			'rc_active'=> 1
		);

        $tblcontact=$this->mdl_general->SaveForm('tblcontract',$contract_data);

//save payment schedule
		
		$contract_data=$this->mdl_general->GetInfoByRow("tblcontract",'rc_id',array('rc_id'=>$tblcontact));

		$info= $this->mdl_general->GetInfoByRow('tblrentperiod','rp_id',array('rp_id'=>$contract_data->rc_unit,'rp_active' =>1));
		$rent_unit = $info->rp_name;
		$rent_day = $info->rp_days;

		$d1 = date('d-m-Y',strtotime($contract_data->rc_fromdate));
		$d2 = date('d-m-Y',strtotime($contract_data->rc_todate));
		$days = (int)abs((strtotime($d1) - strtotime($d2))/(60*60*24));
		$rentcount= ceil($days/$rent_day);
		for($i=0;$i<$rentcount;$i++){
			$day=date('Y-m-d', strtotime($d1. ' + '.$rent_day*$i.' days'));
			$pays=array(
				'rc_id' =>$tblcontact,
				'ps_date' =>$day,
				'ps_amount' => $contract_data->rc_rent,
				'ps_status' => 0
				);
			$this->mdl_general->SaveForm('tblpays',$pays);
        }
        $response=array(
            'status'=>'success',
            'message'=>'Contact added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('transaction/tenantcontract');

    }

    function edit_tenantcontract(){
        $c_id=$this->input->post('rc_id');
        $contract_data=array(
//			"rc_date" =>date('Y-m-d',strtotime($this->input->post('rc_date'))),
			'rc_status'=>$this->input->post('rc_status'),
			'rc_document'=>$this->input->post('rc_document'),
			"rc_fromdate" =>date('Y-m-d',strtotime($this->input->post('rc_fromdate'))),
			"rc_todate" =>date('Y-m-d',strtotime($this->input->post('rc_todate'))),
//			'rc_rent'=>$this->input->post('rc_rent'),
//			'rc_unit'=>$this->input->post('rc_unit'),
			'rc_paymentmode'=>$this->input->post('rc_paymentmode'),
			'rc_bankname'=>$this->input->post('rc_bankname'),
			'rc_sortcode'=>$this->input->post('rc_sortcode'),
			'rc_accountno'=>$this->input->post('rc_accountno'),
			'rc_instruction'=>$this->input->post('rc_instruction'),
			"rc_rentpaydate" =>date('Y-m-d',strtotime($this->input->post('rc_rentpaydate'))),
			'rc_gracedays'=>$this->input->post('rc_gracedays'),
			'rc_deposit'=>$this->input->post('rc_deposit'),
			'rc_surcharge'=>$this->input->post('rc_surcharge'),
			'rc_surunit'=>$this->input->post('rc_surunit'),
//			'rc_reminder'=>$this->input->post('rc_reminder'),
			'rc_remindermode'=>$this->input->post('rc_remindermode'),
//			'rc_reminderdatetime'=>date('Y-m-d H:i:s',strtotime($this->input->post('rc_reminderdatetime'))),
//			'rc_reminderlettertemplate'=>$this->input->post('rc_reminderlettertemplate'),
			'p_id'=>$this->input->post('p_id'),
			't_id'=>$this->input->post('c_id'),
			'rc_active'=> 1
		);
        $this->mdl_general->Manage('tblcontract',$contract_data,array('rc_id'=>$c_id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'Contact updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('transaction/tenantcontract');
    }

    function delete_tenantcontract(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('tblcontract',array('rc_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }
	function rep_propschedule($id){
		$page_details['page_title']="ONYX TECH | Tenant Rent Contract Edit";
		$data['contract_data']=$this->mdl_general->GetInfoByRow('tblcontract','rc_id',array('rc_id'=>$id));
		$data['payrent_data'] = $this->mdl_general->GetAllInfoASC('tblpays','ps_id',array('rc_id'=>$id));
//		$this->load->module('header')->index($page_details);
//		$this->load->module('sidebar')->index($page_details);
		$this->load->view('tenantrentschedule_pdf',$data);

	}

	function letter_tenantcontract($contractid,$letterid){
		$page_details['page_title']="ONYX TECH | Tenant Rent Contract Document";
		$contract_data=$this->mdl_general->GetInfoByRow('tblcontract','rc_id',array('rc_id'=>$contractid));
		$letter=$this->mdl_general->GetInfoByRow('dn_lettertemplate','lt_id',array('lt_id'=>$letterid));
		echo($letter->lt_sub);
		echo("<br/>");
		echo($letter->lt_body);
		echo("<br/>");
		if($letter->lt_footer1active){
			echo($letter->lt_footer1);
			echo("<br/>");
		}
		if($letter->lt_footer2active){
			echo($letter->lt_footer2);
			echo("<br/>");
		}
	}

	function save_reminder(){
		$r_id=$this->input->post('r_upid');
		$active= $this->input->post('r_upactive');
		$info= array(
			'r_date' => date("Y-m-d H:i:s",strtotime($this->input->post('r_update'))),
			'r_mode' => $this->input->post('r_upmode'),
			'r_content' => $this->input->post('r_upcontent'),
			'rc_id' => $this->input->post('r_upcid'),
			'r_active' => ( $active ? '1' :'0')
		);
		if($r_id ==0){
			$this->mdl_general->SaveForm('tblreminder',$info);
		} else {
			$this->mdl_general->Manage('tblreminder',$info,array('r_id'=>$r_id),'Update');
		}
		echo json_encode($info);
	}

	function remove_reminder(){
		$r_id=$this->input->post('id');
		$this->mdl_general->Delete('tblreminder',array('r_id'=>$r_id));
		exit("1");
	}

	function remove_fee(){
		$r_id=$this->input->post('id');
		$this->mdl_general->Delete('tblfee',array('f_id'=>$r_id));
		exit("1");
	}

	function save_fee(){
		$f_id=$this->input->post('f_upid');
		$active= $this->input->post('f_upactive');
		$info= array(
			'f_desc' => $this->input->post('f_desc'),
			'f_amount' => $this->input->post('f_amount'),
			'f_vat' => $this->input->post('f_vat'),
			'f_cid' => $this->input->post('f_upcid'),
			'f_active' => ( $active ? '1' :'0')
		);
		if($f_id ==0){
			$this->mdl_general->SaveForm('tblfee',$info);
		} else {
			$this->mdl_general->Manage('tblfee',$info,array('f_id'=>$f_id),'Update');
		}
		echo json_encode($info);
	}
	
	function rentpayment($type=null,$id=null){
        if($type=='add'){
            $page_details['page_title']="ONYX TECH | Rent Payment";
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('rentpayment_add');
        }elseif($type=='edit' && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Rent Payment";
            $data['contract_data']=$this->mdl_general->GetInfoByRow('tblcontract','rc_id',array('rc_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('rentpayment_edit',$data);
		}elseif($type=='doc' && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Rent Payment Document";
            $data['contract_data']=$this->mdl_general->GetInfoByRow('tblcontract','rc_id',array('rc_id'=>$id));
			$list =$this->mdl_general->GetAllInfo('tblattachletter','al_id',array('cl_id'=>$data['contract_data']->rc_document));
			$templates=array();
			foreach($list as $row){
				$template=$this->mdl_general->GetAllInfo('dn_lettertemplate','lt_id',array('lt_id'=>$row['lt_id']));
				if(count($template)>0)
					$templates=array_merge($templates,$template);
			}
			$data['templates']=$templates;
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('tenantcontract_doc',$data);
        }else{
            $page_details['page_title']="ONYX TECH | Payment List";
			$this->load->model("mdl_extra");
			$date=date("Y-m-d");
			$data['payment_list'] = $this->mdl_extra->GetPaymentList($date);
			///$data['payment_list']=$this->mdl_general->GetAllInfo('tblpays','ps_status', array('ps_date'));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('rentpayment',$data);
			$this->load->module('footer')->index($page_details);
        }
    }
    
    function payrent(){
        $ps_id=$this->input->post('ps_id');
        $ps_otherfee=$this->input->post('ps_otherfee');
        $ps_balance=$this->input->post('ps_balance');
        $ps_pay=$this->input->post('ps_pay');
        $ps_remark=htmlentities($this->input->post('ps_remark'),ENT_QUOTES, "UTF-8");
        $info=$this->mdl_general->GetInfoByRow('tblpays','ps_id',array('ps_id'=>$ps_id));
        $total=$info->ps_amount+$ps_otherfee;
        $paid=$info->ps_paid + $ps_pay;
        $status=0;
        if($paid>=$total)
            $status=1;
        $this->mdl_general->Manage('tblpays',array('ps_paid'=>$paid,'ps_status'=>$status,'ps_paydate'=>date("Y-m-d"),'ps_remark'=>$ps_remark),array('ps_id'=>$ps_id),'Update');
        redirect('transaction/rentpayment');
    }
    
    function rep_rentpay($id){
        $info=$this->mdl_general->GetInfoByRow('tblpays','ps_id',array('ps_id'=>$id));
        $contractinfo=$this->mdl_general->GetInfoByRow('tblcontract','rc_id',array('rc_id'=>$info->rc_id));
        $propertyinfo=$this->mdl_general->GetInfoByRow('tblproperty','p_id',array('p_id'=>$contractinfo->p_id));
        $tenantinfo=$this->mdl_general->GetInfoByRow('tbltenant','c_id',array('c_id'=>$contractinfo->t_id));
        $data['payinfo']=$info;
        $data['contractinfo']=$contractinfo;
        $data['propertyinfo']=$propertyinfo;
        $data['tenantinfo']=$tenantinfo;
        $this->load->view('rentpay_pdf',$data);
    }
    


}