<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Mdl_customer extends CI_Model {

	function __construct() {
        parent::__construct();
    }

    public function get_batch($where_clause = '') {
        // $customers_role_id = $this->get_customers_role_id();
        
        if ($where_clause != '') {
            $this->db->where($where_clause);
        }
        
        // $this->db->where('id_roles', $customers_role_id);
        
        return $this->db->get('dn_client')->result_array();
    }

    public function get_customers_role_id() {
        return $this->db->get_where('ea_roles', array('slug' => DB_SLUG_CUSTOMER))->row()->id;
    }

    public function get_row($customer_id) {
        if (!is_numeric($customer_id)) {
            throw new Exception('Invalid argument provided as $customer_id : ' . $customer_id);
        }
        return $this->db->get_where('dn_client', array('client_id' => $customer_id))->row_array();
    }

    public function add($customer) {
        
        // :: INSERT OR UPDATE CUSTOMER RECORD
        if (!isset($customer['client_id'])) {
            $customer['client_id'] = $this->insert($customer);
        } else {
            $this->update($customer);
        }

        return $customer['client_id'];
    }

    private function update($customer) {        
        // Do not update empty string values.
        foreach ($customer as $key => $value) {
            if ($value === '') 
                unset($customer[$key]);
        }
        var_dump($customer);
        
        $this->db->where('client_id', $customer['client_id']);
        if (!$this->db->update('dn_client', $customer)) {
            throw new Exception('Could not update customer to the database.');
        }
        
        return intval($customer['client_id']);
    }


}