<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Dashboard extends MX_Controller{

	function __construct() {
        parent::__construct();
        $this->load->model('mdl_general');
        if($this->session->userdata('sess_logged_in')!=true){
    			redirect('login/index?error=4');
        }
    }

    function index(){
		//get user list
		$data=array();
		$users=$this->mdl_general->GetAllInfo('mstuser','id',array('user_group'=>1));
		$userlist=array();
		foreach($users as $user){
			$pointsum=0;
			$distance=0;
			$duration=0;
			$points=$this->mdl_general->GetAllInfo('point','id',array('user_id'=>$user['id']));
			foreach($points as $point){
				$pointsum+=$point['points'];
				$distance+=$point['km'];
				$duration+=$point['count_time'];
			}
			$userlist[]=array('id'=>$user['id'],'name'=>$user['name'],'point'=>$pointsum, 'distance'=>$distance,'duration'=>$duration);
		}
		$data['userlist']=$userlist;
		$page_details['page_title']="Dashboard";
        $this->load->Module('header')->index($page_details);
    	$this->load->view('dashboard',$data);
		$this->load->Module('footer')->index($page_details);
    }

	function user($id){
		//get user id
		$points=$this->mdl_general->GetAllInfo('point','id',array('user_id'=>$id));
		$data['points']=$points;
		$page_details['page_title']="User orders";
        $this->load->Module('header')->index($page_details);
    	$this->load->view('user',$data);
		$this->load->Module('footer')->index($page_details);
    }
	
}