<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Mdl_providers extends CI_Model {

	function __construct() {
        parent::__construct();
    }

    function GetAvailableProviders(){
    	// Get provider records from database.
        $this->db
                ->select('acs_user.*')
                ->from('acs_user')  
                ->join('acs_user_roles', 'acs_user_roles.role_id = acs_user.role_id', 'inner')
                ->where('acs_user_roles.slug','provider');
        
        $providers = $this->db->get()->result_array();
        
        // Include each provider services and settings.
        foreach($providers as &$provider) {
            // Services
            $services = $this->db->get_where('dn_services_providers', 
                    array('id_users' => $provider['u_id']))->result_array();
            $provider['services'] = array();
            foreach($services as $service) {
                $provider['services'][] = $service['id_services'];
            }
            
            // Settings
            // $provider['settings'] = $this->db->get_where('ea_user_settings', 
            //         array('id_users' => $provider['id']))->row_array();
            // unset($provider['settings']['id_users']);
        }
        
        // Return provider records.
        return $providers;
    }

    public function get_row($provider_id) {
        if (!is_numeric($provider_id)) {
            throw new Exception('$provider_id argument is not a valid numeric value: ' . $provider_id);
        }
        
        // Check if selected record exists on database. 
        if ($this->db->get_where('acs_user', array('u_id' => $provider_id))->num_rows() == 0) {
            throw new Exception('Selected record does not exist in the database.');
        }
        
        // Get provider data.
        $provider = $this->db->get_where('acs_user', array('u_id' => $provider_id))->row_array();
        
       
        // Include provider services.
        $services = $this->db->get_where('dn_services_providers', 
                array('id_users' => $provider_id))->result_array();
        $provider['services'] = array();
        foreach($services as $service) {
            $provider['services'][] = $service['id_services'];
        }

        // Include provider settings.
        // $provider['settings'] = $this->db->get_where('ea_user_settings', 
        //         array('id_users' => $provider_id))->row_array();
        // unset($provider['settings']['id_users']);

        // Return provider data array.
        return $provider;
    }
}