<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Setup extends MX_Controller{

    function __construct() {
        parent::__construct();
        $this->load->model('mdl_general');
        if($this->session->userdata('sess_logged_in')!=true){
                redirect('login/index?error=4');
        }

    }

    /*function index(){
        $data['page_title']='ONYX TECH | Setup';
    }*/

	//for contact add

    //for city setup
    function city($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | City edit";
            $data['city_details']=$this->mdl_general->GetInfoByRow('dn_city','city_id',array('city_id'=>$id));

            $this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('city_edit',$data);
			$this->load->module('footer')->index($page_details);

        }else{
			$page_details['page_title']="ONYX TECH | City";
			$data['city_list']=$this->mdl_general->GetAllInfo('dn_city','city_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('city',$data);
			$this->load->module('footer')->index($page_details);
		}
    }

    function add_new_city(){
        $active=$this->input->post('cityActive');
        $form_data=array(
            'country_id'=>$this->input->post('countryName'),
            'city_name'=>$this->input->post('cityName'),
            'city_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->SaveForm('dn_city',$form_data);
        $response=array(
            'status'=>'success',
            'message'=>'City added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/city');

    }
    function delete_city(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('dn_city',array('city_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

    function city_edit(){
        $active=$this->input->post('cityActive');
        $id=$this->input->post('hdnCityId');
        $form_data=array(
            'country_id'=>$this->input->post('countryName'),
            'city_name'=>$this->input->post('cityName'),
            'city_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->Manage('dn_city',$form_data,array('city_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'City updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/city');

    }

    //for country setup

    function country($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Country edit";
            $data['country_details']=$this->mdl_general->GetInfoByRow('dn_country','country_id',array('country_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('country_edit',$data);
			$this->load->module('footer')->index($page_details);


        }else{
            $page_details['page_title']="ONYX TECH | Country";
        $data['country_list']=$this->mdl_general->GetAllInfo('dn_country','country_id');
        $this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('country',$data);
			$this->load->module('footer')->index($page_details);
        }

    }

    function add_new_country(){
        $active=$this->input->post('countryActive');
        $form_data=array(

            'country_name'=>$this->input->post('countryName'),
            'country_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->SaveForm('dn_country',$form_data);
        $response=array(
            'status'=>'success',
            'message'=>'Country added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/country');


    }

    function delete_country(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('dn_country',array('country_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

    function country_edit(){
        $active=$this->input->post('countryActive');
        $id=$this->input->post('hdnCountryId');
        $form_data=array(

            'country_name'=>$this->input->post('countryName'),
            'country_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->Manage('dn_country',$form_data,array('country_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'Country updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/country');
    }



    //for clienttype

	function clienttype($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Client type edit";
            $data['client_type_details']=$this->mdl_general->GetInfoByRow('dn_clienttype','clienttype_id',array('clienttype_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('client_type_edit',$data);
			$this->load->module('footer')->index($page_details);

        }else{

			$page_details['page_title']="ONYX TECH | Client Type";
			$data['client_type_list']=$this->mdl_general->GetAllInfo('dn_clienttype','clienttype_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('client_type',$data);
			$this->load->module('footer')->index($page_details);
		}
    }

    function add_new_clienttype(){
        $active=$this->input->post('clientTypeActive');
        $form_data=array(

            'clienttype_name'=>$this->input->post('clientTypeName'),
            'clienttype_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->SaveForm('dn_clienttype',$form_data);
        $response=array(
            'status'=>'success',
            'message'=>'client type added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/clienttype');

    }

    function delete_clienttype(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('dn_clienttype',array('clienttype_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

    function clienttype_edit(){
        $active=$this->input->post('clientTypeActive');
        $id=$this->input->post('hdnclientTypeId');
        $form_data=array(

            'clienttype_name'=>$this->input->post('clientTypeName'),
            'clienttype_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->Manage('dn_clienttype',$form_data,array('clienttype_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'client type updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/clienttype');
    }


    //for title

    function title($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Title edit";
            $data['title_details']=$this->mdl_general->GetInfoByRow('dn_title','title_id',array('title_id'=>$id));

			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('title_edit',$data);
			$this->load->module('footer')->index($page_details);


        }else{

        $page_details['page_title']="ONYX TECH | Title";
        $data['title_list']=$this->mdl_general->GetAllInfo('dn_title','title_id');

		$this->load->module('header')->index($page_details);
		$this->load->module('sidebar')->index($page_details);
		$this->load->view('title',$data);
		$this->load->module('footer')->index($page_details);
    }
    }

    function add_new_title(){
        $active=$this->input->post('titleActive');
        $form_data=array(

            'title_name'=>$this->input->post('titleName'),
            'title_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->SaveForm('dn_title',$form_data);
        $response=array(
            'status'=>'success',
            'message'=>'Title added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/title');

    }

    function delete_title(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('dn_title',array('title_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);

    }

    function title_edit(){
        $active=$this->input->post('titleActive');
        $id=$this->input->post('hdnTitleId');
        $form_data=array(

            'title_name'=>$this->input->post('titleName'),
            'title_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->Manage('dn_title',$form_data,array('title_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'Title updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/title');

    }



    //for configuration
    //default=1
    function configuration($id='1'){
            $page_details['page_title']="ONYX TECH | Configuration Edit";
            $data['configuration']=$this->mdl_general->GetInfoByRow('acs_configration','config_id',array('config_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('configuration_edit',$data);
			$this->load->module('footer')->index($page_details);
    }

    function configuration_edit(){
            $registration_email=$this->input->post('dnRegistrationEmail');
            $registration_sms=$this->input->post('dnRegistrationSMS');
            $event_email=$this->input->post('eventEmail');
            $event_sms=$this->input->post('eventSMS');
            $approval_disabled=$this->input->post('companyApprovalDisabled');
            $id=$this->input->post('hdnConfigurationId');

            if(@$_FILES['companySignatureImage']['name'] != ""){
                $config['upload_path'] = FCPATH . 'src/img/setUpwindow/';
                    $config['allowed_types'] = 'jpeg|png|jpg|PNG|JPG|bmp|BMP';
                    $config['encrypt_name'] = FALSE;
                    $config['remove_spaces'] = FALSE;
                    $config['max_size'] = '2048';

                    $this->upload_file($config,'companySignatureImage');
                    $this->mdl_general->Manage('acs_configration',array('signatureimage' => $_FILES['companySignatureImage']['name']), array('config_id' => $id), 'update');


            }
            if(@$_FILES['companyLogo']['name'] != ""){
                    $config['upload_path'] = FCPATH . 'src/img/setUpwindow/';
                    $config['allowed_types'] = 'jpeg|png|PNG|jpg|JPG|bmp|BMP';
                    $config['encrypt_name'] = FALSE;
                    $config['remove_spaces'] = FALSE;
                    $config['max_size'] = '2048';
                    $this->upload_file($config,'companyLogo');
                    $this->mdl_general->Manage('acs_configration',array('logo' => $_FILES['companyLogo']['name']), array('config_id' => $id), 'update');

            }

        $form_data=array(
            'company_name'=>$this->input->post('companyName'),
            'address'=>$this->input->post('companyAddress'),
            'phone'=>$this->input->post('companyPhone'),
            'fax'=>$this->input->post('companyFax'),
            'email'=>$this->input->post('companyEmail'),
            'website'=>$this->input->post('companyWebsite'),
            'smsuser'=>$this->input->post('companySMSUser'),
            'smspass'=>$this->input->post('companySMSPassword'),
            'emailsendername'=>$this->input->post('companyEmailSenderName'),
            'emailsenderaddress'=>$this->input->post('companyEmailSenderID'),
            'signaturetext'=>$this->input->post('companySignatureText'),
            'eventemailtext'=>$this->input->post('eventEmailText'),
            'eventsmstext'=>$this->input->post('eventSMSText'),
            'registration_email'=>($registration_email ? $registration_email :'0'),
            'registration_sms'=>($registration_sms ? $registration_sms :'0'),
            'event_email'=>($event_email ? $event_email :'0'),
            'event_sms'=>($event_sms ? $event_sms :'0'),
			'emailtotenantatregister'=>($event_sms ? $event_sms :'0'),
			'smstotenantatregister'=>($event_sms ? $event_sms :'0'),
            'approval_disabled'=>($approval_disabled ? $approval_disabled :'0')
        );
        $this->mdl_general->Manage('acs_configration',$form_data,array('config_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'Configuration updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/configuration');

    }

    function upload_file($config, $fieldname) {
        $this->load->library('upload');
        $this->upload->initialize($config);
        $this->upload->do_upload($fieldname);
    }



    //for labletemplate

    function labeltemplate($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Label template edit";
            $data['template']=$this->mdl_general->GetInfoByRow('labelmeasurements','lb_id',array('lb_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('labeltemplate_edit',$data);
			$this->load->module('footer')->index($page_details);

        }else{
            $page_details['page_title']="ONYX TECH | Label template";
            $data['template_list']=$this->mdl_general->GetAllInfo('labelmeasurements','lb_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('labeltemplate',$data);
			$this->load->module('footer')->index($page_details);
        }
    }

    function add_new_labeltemplate(){
        $form_data=array(

            'lb_width'=>$this->input->post('labelWidth'),
            'lb_height'=>$this->input->post('labelHeight'),
            'lb_leftmargin'=>$this->input->post('labelLeftMargin'),
            'lb_topmargin'=>$this->input->post('labelTopMargin'),
            'lb_leftpadding'=>$this->input->post('labelLeftDistance'),
            'lb_toppadding'=>$this->input->post('labelTopDistance'),
            'lb_vspace'=>$this->input->post('labelVerticalSpace'),
            'lb_hspace'=>$this->input->post('labelHorizontalSpace'),
            'lb_text'=>$this->input->post('labelText'),
            'lb_name'=>$this->input->post('labelName'),
            'lb_lineheight'=>$this->input->post('labelBwLineDistance'),
            'pagebreakheight'=>$this->input->post('labelPageBreakHeight'),
            'pageheight'=>$this->input->post('labelPageHeight'),
            'pagewidth'=>$this->input->post('labelPageWidth'),
            'pagequality'=>$this->input->post('labelPage')
        );
        $this->mdl_general->SaveForm('labelmeasurements',$form_data);
        $response=array(
            'status'=>'success',
            'message'=>'Label template added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/labeltemplate');

    }

    function labeltemplate_edit(){
        $id=$this->input->post('hdnLabelTemplateId');
        $form_data=array(

            'lb_width'=>$this->input->post('labelWidth'),
            'lb_height'=>$this->input->post('labelHeight'),
            'lb_leftmargin'=>$this->input->post('labelLeftMargin'),
            'lb_topmargin'=>$this->input->post('labelTopMargin'),
            'lb_leftpadding'=>$this->input->post('labelLeftDistance'),
            'lb_toppadding'=>$this->input->post('labelTopDistance'),
            'lb_vspace'=>$this->input->post('labelVerticalSpace'),
            'lb_hspace'=>$this->input->post('labelHorizontalSpace'),
            'lb_text'=>$this->input->post('labelText'),
            'lb_name'=>$this->input->post('labelName'),
            'lb_lineheight'=>$this->input->post('labelBwLineDistance'),
            'pagebreakheight'=>$this->input->post('labelPageBreakHeight'),
            'pageheight'=>$this->input->post('labelPageHeight'),
            'pagewidth'=>$this->input->post('labelPageWidth'),
            'pagequality'=>$this->input->post('labelPage')
        );
        $this->mdl_general->Manage('labelmeasurements',$form_data,array('lb_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'Label template updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/labeltemplate');

    }

    function delete_labeltemplate(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('labelmeasurements',array('lb_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);

    }


    //for letter template
    function template($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Letter template edit";
            $data['template']=$this->mdl_general->GetInfoByRow('dn_lettertemplate','lt_id',array('lt_id'=>$id));

			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('lettertemplate_edit',$data);
			$this->load->module('footer')->index($page_details);



        }else{
            $page_details['page_title']="ONYX TECH | Letter template";
            $data['template_list']=$this->mdl_general->GetAllInfo('dn_lettertemplate','lt_id');

			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('lettertemplate',$data);
			$this->load->module('footer')->index($page_details);
        }
    }

    function add_new_template(){
        $lt_footer1active=$this->input->post('ltFooter1Active');
        $lt_footer2active=$this->input->post('ltFooter2Active');
        $lt_active=$this->input->post('ltActive');

        $form_data=array(
            'lt_name'=>$this->input->post('ltHeader'),
            'lt_sub'=>$this->input->post('ltSubject'),
            'lt_body'=>$this->input->post('ltBody'),
            'lt_footer1'=>$this->input->post('ltFooter1'),
            'lt_footer2'=>$this->input->post('ltFooter2'),
            'lt_footer1active'=>($lt_footer1active ? $lt_footer1active :'0'),
            'lt_footer2active'=>($lt_footer2active ? $lt_footer2active :'0'),
            'lt_active'=>($lt_active ? $lt_active :'0'),
			'lt_type'=>$this->input->post('lttype'),
			'lt_tempf'=>$this->input->post('lttempf'),
            'lt_des'=>$this->input->post('ltDesignation')
        );
        $template_id=$this->mdl_general->SaveForm('dn_lettertemplate',$form_data);

        if(@$_FILES['ltSignatureImage']['name'] != ""){
                    $config['upload_path'] = FCPATH . 'src/image/letterTemplate';
                    $config['allowed_types'] = 'jpeg|png|PNG|jpg|JPG|bmp|BMP';
                    $config['encrypt_name'] = FALSE;
                    $config['remove_spaces'] = FALSE;
                    $config['max_size'] = '2048';
                    $this->upload_file($config,'ltSignatureImage');
                    $this->mdl_general->Manage('dn_lettertemplate',array('signatureimage' => $_FILES['ltSignatureImage']['name']), array('lt_id' => $template_id), 'Update');

        }

        $response=array(
            'status'=>'success',
            'message'=>'Letter template added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/template');


    }

    function template_edit(){
        $lt_footer1active=$this->input->post('ltFooter1Active');
        $lt_footer2active=$this->input->post('ltFooter2Active');
        $lt_active=$this->input->post('ltActive');
        $id=$this->input->post('hdnLetterTemplateId');

        $form_data=array(
            'lt_name'=>$this->input->post('ltHeader'),
            'lt_sub'=>$this->input->post('ltSubject'),
            'lt_body'=>$this->input->post('ltBody'),
            'lt_footer1'=>$this->input->post('ltFooter1'),
            'lt_footer2'=>$this->input->post('ltFooter2'),
            'lt_footer1active'=>($lt_footer1active ? $lt_footer1active :'0'),
            'lt_footer2active'=>($lt_footer2active ? $lt_footer2active :'0'),
            'lt_active'=>($lt_active ? $lt_active :'0'),
            'lt_type'=>$this->input->post('lttype'),
			'lt_tempf'=>$this->input->post('lttempf'),
            'lt_des'=>$this->input->post('ltDesignation')
        );
        $this->mdl_general->Manage('dn_lettertemplate',$form_data,array('lt_id'=>$id),'Update');

        if(@$_FILES['ltSignatureImage']['name'] != ""){
                    $config['upload_path'] = FCPATH . 'src/image/letterTemplate';
                    $config['allowed_types'] = 'jpeg|png|PNG|jpg|JPG|bmp|BMP';
                    $config['encrypt_name'] = FALSE;
                    $config['remove_spaces'] = FALSE;
                    $config['max_size'] = '2048';
                    $this->upload_file($config,'ltSignatureImage');
                    $this->mdl_general->Manage('dn_lettertemplate',array('signatureimage' => $_FILES['ltSignatureImage']['name']), array('lt_id' => $id), 'Update');

        }

        $response=array(
            'status'=>'success',
            'message'=>'Letter template updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/template');


    }

    function delete_template(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('dn_lettertemplate',array('lt_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);

    }

    function services($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Services edit";
            $data['service']=$this->mdl_general->GetInfoByRow('dn_services','service_id',array('service_id'=>$id));

			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('services_edit',$data);
			$this->load->module('footer')->index($page_details);


        }else{
            $page_details['page_title']="ONYX TECH | Services";
            $data['services_list']=$this->mdl_general->GetAllInfo('dn_services','service_id');

			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('services',$data);
			$this->load->module('footer')->index($page_details);
        }
    }

    function add_new_service(){
        $form_data=array(
            'name'=>$this->input->post('serviceName'),
            'duration'=>$this->input->post('serviceDuration'),
            'price'=>$this->input->post('servicePrice'),
            'currency'=>$this->input->post('serviceCurrency'),
            'description'=>$this->input->post('serviceDescription'),
            'id_service_categories'=>$this->input->post('serviceCategory')
        );
        $this->mdl_general->SaveForm('dn_services',$form_data);
        $response=array(
            'status'=>'success',
            'message'=>'Service  added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/services');
    }

    function edit_service(){
        $id=$this->input->post('hdnServiceId');
        $form_data=array(
            'name'=>$this->input->post('serviceName'),
            'duration'=>$this->input->post('serviceDuration'),
            'price'=>$this->input->post('servicePrice'),
            'currency'=>$this->input->post('serviceCurrency'),
            'description'=>$this->input->post('serviceDescription'),
            'id_service_categories'=>$this->input->post('serviceCategory')
        );
        $this->mdl_general->Manage('dn_services',$form_data,array('service_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'Service updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/services');
    }

    function delete_service($edit=null,$id=null){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('dn_services',array('service_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);

    }

    function services_category($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Services category edit";
            $data['category']=$this->mdl_general->GetInfoByRow('dn_service_categories','id',array('id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('services_category_edit',$data);
			$this->load->module('footer')->index($page_details);


        }else{
            $page_details['page_title']="ONYX TECH | Services category";
            $data['service_category_list']=$this->mdl_general->GetAllInfo('dn_service_categories','id');
            $this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('services_category',$data);
			$this->load->module('footer')->index($page_details);
        }
    }

    function add_new_service_category(){
        $form_data=array(
            'name'=>$this->input->post('serviceCategoryName'),
            'description'=>$this->input->post('serviceCategoryDescription')
        );
        $this->mdl_general->SaveForm('dn_service_categories',$form_data);
        $response=array(
            'status'=>'success',
            'message'=>'Service Category added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/services_category');
    }

    function edit_service_category(){
        $id=$this->input->post('hdnServiceCategoryId');
        $form_data=array(
            'name'=>$this->input->post('serviceCategoryName'),
            'description'=>$this->input->post('serviceCategoryDescription')
        );
        $this->mdl_general->Manage('dn_service_categories',$form_data,array('id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'Service category updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/services_category');
    }

    function delete_service_category(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('dn_service_categories',array('id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

	function area($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Area edit";
            $data['area']=$this->mdl_general->GetInfoByRow('tblarea','a_id',array('a_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('area_edit',$data);
			$this->load->module('footer')->index($page_details);


        }else{
            $page_details['page_title']="ONYX TECH | Area";
            $data['area_list']=$this->mdl_general->GetAllInfo('tblarea','a_id');
            $this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
            $this->load->view('area',$data);
			$this->load->module('footer')->index($page_details);
        }
    }

    function add_new_area(){
		$active=$this->input->post('a_active');
        $form_data=array(
            'a_name'=>$this->input->post('a_name'),
			'a_city'=>$this->input->post('a_city'),
            'a_description'=>$this->input->post('a_description'),
			'a_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->SaveForm('tblarea',$form_data);
        $response=array(
            'status'=>'success',
            'message'=>'Area added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/area');
    }

    function edit_area(){
        $id=$this->input->post('a_id');
		$active=$this->input->post('a_active');
        $form_data=array(
            'a_name'=>$this->input->post('a_name'),
			'a_city'=>$this->input->post('a_city'),
            'a_description'=>$this->input->post('a_description'),
			'a_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->Manage('tblarea',$form_data,array('a_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'Service category updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/area');
    }

    function delete_area(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('tblarea',array('a_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

	function propertype($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Property type edit";
            $data['property_type_details']=$this->mdl_general->GetInfoByRow('tblpropertype','pt_id',array('pt_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('property_type_edit',$data);
			$this->load->module('footer')->index($page_details);

        }else{

			$page_details['page_title']="ONYX TECH | Client Type";
			$data['property_type_list']=$this->mdl_general->GetAllInfo('tblpropertype','pt_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('property_type',$data);
			$this->load->module('footer')->index($page_details);
		}
    }

    function add_new_propertytype(){
        $active=$this->input->post('propertyTypeActive');
        $form_data=array(

            'pt_name'=>$this->input->post('propertyTypeName'),
            'pt_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->SaveForm('tblpropertype',$form_data);
        $response=array(
            'status'=>'success',
            'message'=>'client type added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/propertype');

    }

    function delete_propertytype(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('tblpropertype',array('pt_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

    function propertype_edit(){
        $active=$this->input->post('propertyTypeActive');
        $id=$this->input->post('hdnpropertyTypeId');
        $form_data=array(

            'pt_name'=>$this->input->post('propertyTypeName'),
            'pt_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->Manage('tblpropertype',$form_data,array('pt_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'client type updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/propertype');
    }

	//lettertype
	function lettertype($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Letter type edit";
            $data['letter_type_details']=$this->mdl_general->GetInfoByRow('tbllettertype','lt_id',array('lt_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('lettertype_edit',$data);
			$this->load->module('footer')->index($page_details);

        }else{

			$page_details['page_title']="ONYX TECH | Letter Type";
			$data['letter_type_list']=$this->mdl_general->GetAllInfo('tbllettertype','lt_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('lettertype',$data);
			$this->load->module('footer')->index($page_details);
		}
    }

    function add_new_lettertype(){
        $active=$this->input->post('lt_active');
        $form_data=array(

            'lt_name'=>$this->input->post('lt_name'),
            'lt_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->SaveForm('tbllettertype',$form_data);
        $response=array(
            'status'=>'success',
            'message'=>'letter type added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/lettertype');

    }

    function delete_lettertype(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('tbllettertype',array('lt_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

    function lettertype_edit(){
        $active=$this->input->post('lt_active');
        $id=$this->input->post('lt_id');
        $form_data=array(

            'lt_name'=>$this->input->post('lt_name'),
            'lt_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->Manage('tbllettertype',$form_data,array('lt_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'letter type updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/lettertype');
    }
// Designation

	function designation($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Designation edit";
            $data['designation_details']=$this->mdl_general->GetInfoByRow('tbldesignation','d_id',array('d_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('designation_edit',$data);
			$this->load->module('footer')->index($page_details);

        }else{

			$page_details['page_title']="ONYX TECH | Designation";
			$data['designation_list']=$this->mdl_general->GetAllInfo('tbldesignation','d_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('designation',$data);
			$this->load->module('footer')->index($page_details);
		}
    }

    function add_new_designation(){
        $active=$this->input->post('d_active');
        $form_data=array(

            'd_name'=>$this->input->post('d_name'),
            'd_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->SaveForm('tbldesignation',$form_data);
        $response=array(
            'status'=>'success',
            'message'=>'designation added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/designation');

    }

    function delete_designation(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('tbldesignation',array('d_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

    function designation_edit(){
        $active=$this->input->post('d_active');
        $id=$this->input->post('d_id');
        $form_data=array(

            'd_name'=>$this->input->post('d_name'),
            'd_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->Manage('tbldesignation',$form_data,array('d_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'Designation updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/designation');
    }
//templatefor
	function templatefor($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Template For edit";
            $data['templatefor_details']=$this->mdl_general->GetInfoByRow('tbltemplatefor','tf_id',array('tf_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('templatefor_edit',$data);
			$this->load->module('footer')->index($page_details);

        }else{

			$page_details['page_title']="ONYX TECH | Template For";
			$data['templatefor_list']=$this->mdl_general->GetAllInfo('tbltemplatefor','tf_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('templatefor',$data);
			$this->load->module('footer')->index($page_details);
		}
    }

    function add_new_templatefor(){
        $active=$this->input->post('tf_active');
        $form_data=array(

            'tf_name'=>$this->input->post('tf_name'),
            'tf_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->SaveForm('tbltemplatefor',$form_data);
        $response=array(
            'status'=>'success',
            'message'=>'templatefor added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/templatefor');

    }

    function delete_templatefor(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('tbltemplatefor',array('tf_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

    function templatefor_edit(){
        $active=$this->input->post('tf_active');
        $id=$this->input->post('tf_id');
        $form_data=array(

            'tf_name'=>$this->input->post('tf_name'),
            'tf_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->Manage('tbltemplatefor',$form_data,array('tf_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'TemplateFor updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/templatefor');
    }

///category

	function category($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Category edit";
            $data['category_details']=$this->mdl_general->GetInfoByRow('tblcategory','c_id',array('c_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('category_edit',$data);
			$this->load->module('footer')->index($page_details);

        }else{

			$page_details['page_title']="ONYX TECH | Category";
			$data['category_list']=$this->mdl_general->GetAllInfo('tblcategory','c_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('category',$data);
			$this->load->module('footer')->index($page_details);
		}
    }

    function add_new_category(){
        $active=$this->input->post('c_active');
        $form_data=array(

            'c_name'=>$this->input->post('c_name'),
            'c_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->SaveForm('tblcategory',$form_data);
        $response=array(
            'status'=>'success',
            'message'=>'category added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/category');

    }

    function delete_category(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('tblcategory',array('c_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

    function category_edit(){
        $active=$this->input->post('c_active');
        $id=$this->input->post('c_id');
        $form_data=array(

            'c_name'=>$this->input->post('c_name'),
            'c_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->Manage('tblcategory',$form_data,array('c_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'Category updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/category');
    }
//status
	function status($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Status edit";
            $data['status_details']=$this->mdl_general->GetInfoByRow('tblstatus','s_id',array('s_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('status_edit',$data);
			$this->load->module('footer')->index($page_details);

        }else{

			$page_details['page_title']="ONYX TECH | Status";
			$data['status_list']=$this->mdl_general->GetAllInfo('tblstatus','s_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('status',$data);
			$this->load->module('footer')->index($page_details);
		}
    }

    function add_new_status(){
        $active=$this->input->post('s_active');
        $form_data=array(

            's_name'=>$this->input->post('s_name'),
            's_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->SaveForm('tblstatus',$form_data);
        $response=array(
            'status'=>'success',
            'message'=>'status added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/status');

    }

    function delete_status(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('tblstatus',array('s_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

    function status_edit(){
        $active=$this->input->post('s_active');
        $id=$this->input->post('s_id');
        $form_data=array(

            's_name'=>$this->input->post('s_name'),
            's_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->Manage('tblstatus',$form_data,array('s_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'Status updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/status');
    }

//price

	function price($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Price edit";
            $data['price_details']=$this->mdl_general->GetInfoByRow('tblprice','p_id',array('p_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('price_edit',$data);
			$this->load->module('footer')->index($page_details);

        }else{

			$page_details['page_title']="ONYX TECH | Price";
			$data['price_list']=$this->mdl_general->GetAllInfo('tblprice','p_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('price',$data);
			$this->load->module('footer')->index($page_details);
		}
    }

    function add_new_price(){
        $active=$this->input->post('p_active');
        $form_data=array(

            'p_name'=>$this->input->post('p_name'),
            'p_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->SaveForm('tblprice',$form_data);
        $response=array(
            'price'=>'success',
            'message'=>'price added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/price');

    }

    function delete_price(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('tblprice',array('p_id'=>$id));
        $response=array(
            'price'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

    function price_edit(){
        $active=$this->input->post('p_active');
        $id=$this->input->post('p_id');
        $form_data=array(

            'p_name'=>$this->input->post('p_name'),
            'p_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->Manage('tblprice',$form_data,array('p_id'=>$id),'Update');
        $response=array(
            'price'=>'success',
            'message'=>'Price updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/price');
    }
//////local auth

	function localauth($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Local Authority edit";
            $data['localauth_details']=$this->mdl_general->GetInfoByRow('tbllocalauth','la_id',array('la_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('localauth_edit',$data);
			$this->load->module('footer')->index($page_details);

        }else{

			$page_details['page_title']="ONYX TECH | Local Authority";
			$data['localauth_list']=$this->mdl_general->GetAllInfo('tbllocalauth','la_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('localauth',$data);
			$this->load->module('footer')->index($page_details);
		}
    }

    function add_new_localauth(){
        $active=$this->input->post('la_active');
        $form_data=array(

            'la_name'=>$this->input->post('la_name'),
            'la_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->SaveForm('tbllocalauth',$form_data);
        $response=array(
            'status'=>'success',
            'message'=>'localauth added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/localauth');

    }

    function delete_localauth(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('tbllocalauth',array('la_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

    function localauth_edit(){
        $active=$this->input->post('la_active');
        $id=$this->input->post('la_id');
        $form_data=array(

            'la_name'=>$this->input->post('la_name'),
            'la_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->Manage('tbllocalauth',$form_data,array('la_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'Local Authority updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/localauth');
    }
//taxband
	function taxband($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Tax Band edit";
            $data['taxband_details']=$this->mdl_general->GetInfoByRow('tbltaxband','tb_id',array('tb_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('taxband_edit',$data);
			$this->load->module('footer')->index($page_details);

        }else{

			$page_details['page_title']="ONYX TECH | Tax Band";
			$data['taxband_list']=$this->mdl_general->GetAllInfo('tbltaxband','tb_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('taxband',$data);
			$this->load->module('footer')->index($page_details);
		}
    }

    function add_new_taxband(){
        $active=$this->input->post('tb_active');
        $form_data=array(
            'tb_name'=>$this->input->post('tb_name'),
			'tb_council'=>$this->input->post('tb_council'),
			'tb_water'=>$this->input->post('tb_water'),
			'tb_drainage'=>$this->input->post('tb_drainage'),
            'tb_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->SaveForm('tbltaxband',$form_data);
        $response=array(
            'status'=>'success',
            'message'=>'taxband added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/taxband');

    }

    function delete_taxband(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('tbltaxband',array('tb_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

    function taxband_edit(){
        $active=$this->input->post('tb_active');
        $id=$this->input->post('tb_id');
        $form_data=array(

            'tb_name'=>$this->input->post('tb_name'),
			'tb_council'=>$this->input->post('tb_council'),
			'tb_water'=>$this->input->post('tb_water'),
			'tb_drainage'=>$this->input->post('tb_drainage'),
            'tb_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->Manage('tbltaxband',$form_data,array('tb_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'Tax Band updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/taxband');
    }
//rent period
	function rentperiod($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Rent Period edit";
            $data['rentperiod_details']=$this->mdl_general->GetInfoByRow('tblrentperiod','rp_id',array('rp_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('rentperiod_edit',$data);
			$this->load->module('footer')->index($page_details);

        }else{

			$page_details['page_title']="ONYX TECH | Rent Period";
			$data['rentperiod_list']=$this->mdl_general->GetAllInfo('tblrentperiod','rp_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('rentperiod',$data);
			$this->load->module('footer')->index($page_details);
		}
    }

    function add_new_rentperiod(){
        $active=$this->input->post('rp_active');
        $form_data=array(

            'rp_name'=>$this->input->post('rp_name'),
			'rp_days'=>$this->input->post('rp_days'),
            'rp_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->SaveForm('tblrentperiod',$form_data);
        $response=array(
            'status'=>'success',
            'message'=>'rentperiod added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/rentperiod');

    }

    function delete_rentperiod(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('tblrentperiod',array('rp_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

    function rentperiod_edit(){
        $active=$this->input->post('rp_active');
        $id=$this->input->post('rp_id');
        $form_data=array(

            'rp_name'=>$this->input->post('rp_name'),
			'rp_days'=>$this->input->post('rp_days'),
            'rp_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->Manage('tblrentperiod',$form_data,array('rp_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'Rent Period updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/rentperiod');
    }

//paymentmode
	function paymentmode($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Payment Mode edit";
            $data['payment_mode_details']=$this->mdl_general->GetInfoByRow('tblpaymentmode','pm_id',array('pm_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('paymentmode_edit',$data);
			$this->load->module('footer')->index($page_details);

        }else{

			$page_details['page_title']="ONYX TECH | Payment Mode";
			$data['payment_mode_list']=$this->mdl_general->GetAllInfo('tblpaymentmode','pm_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('paymentmode',$data);
			$this->load->module('footer')->index($page_details);
		}
    }

    function add_new_paymentmode(){
        $active=$this->input->post('pm_active');
        $form_data=array(

            'pm_name'=>$this->input->post('pm_name'),
            'pm_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->SaveForm('tblpaymentmode',$form_data);
        $response=array(
            'status'=>'success',
            'message'=>'letter type added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/paymentmode');

    }

    function delete_paymentmode(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('tblpaymentmode',array('pm_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

    function paymentmode_edit(){
        $active=$this->input->post('pm_active');
        $id=$this->input->post('pm_id');
        $form_data=array(

            'pm_name'=>$this->input->post('pm_name'),
            'pm_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->Manage('tblpaymentmode',$form_data,array('pm_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'letter type updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/paymentmode');
    }
//remindermode
	function remindermode($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Reminder Mode edit";
            $data['reminder_mode_details']=$this->mdl_general->GetInfoByRow('tblremindermode','rm_id',array('rm_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('remindermode_edit',$data);
			$this->load->module('footer')->index($page_details);

        }else{

			$page_details['page_title']="ONYX TECH | Reminder Mode";
			$data['reminder_mode_list']=$this->mdl_general->GetAllInfo('tblremindermode','rm_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('remindermode',$data);
			$this->load->module('footer')->index($page_details);
		}
    }

    function add_new_remindermode(){
        $active=$this->input->post('rm_active');
        $form_data=array(

            'rm_name'=>$this->input->post('rm_name'),
            'rm_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->SaveForm('tblremindermode',$form_data);
        $response=array(
            'status'=>'success',
            'message'=>'letter type added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/remindermode');

    }

    function delete_remindermode(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('tblremindermode',array('rm_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

    function remindermode_edit(){
        $active=$this->input->post('rm_active');
        $id=$this->input->post('rm_id');
        $form_data=array(

            'rm_name'=>$this->input->post('rm_name'),
            'rm_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->Manage('tblremindermode',$form_data,array('rm_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'letter type updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/remindermode');
    }
//remindermode
	function contractletter($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Contract Letter edit";
            $data['contract_letter_details']=$this->mdl_general->GetInfoByRow('tblcontractletter','cl_id',array('cl_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('contractletter_edit',$data);
			$this->load->module('footer')->index($page_details);

        }else{

			$page_details['page_title']="ONYX TECH | Contract Letter";
			$data['contract_letter_list']=$this->mdl_general->GetAllInfo('tblcontractletter','cl_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('contractletter',$data);
			$this->load->module('footer')->index($page_details);
		}
    }

    function add_new_contractletter(){
        $active=$this->input->post('cl_active');
        $focl_data=array(

            'cl_name'=>$this->input->post('cl_name'),
            'cl_active'=>( $active ? $active :'0')
        );
        $id=$this->mdl_general->SaveForm('tblcontractletter',$focl_data);
		$attcount=$this->input->post('attid');
		for($i=0;$i<$attcount;$i++)
		{
			$val=$this->input->post('lt_temp'.$i);
			if(!empty($val)){
				 $this->mdl_general->SaveForm('tblattachletter',array('cl_id'=>$id,'lt_id'=>$val));

			}
		}
        $response=array(
            'status'=>'success',
            'message'=>'letter type added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/contractletter');

    }

    function delete_contractletter(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('tblcontractletter',array('cl_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

    function contractletter_edit(){
        $active=$this->input->post('cl_active');
        $id=$this->input->post('cl_id');
        $focl_data=array(

            'cl_name'=>$this->input->post('cl_name'),
            'cl_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->Manage('tblcontractletter',$focl_data,array('cl_id'=>$id),'Update');
		$this->mdl_general->Delete('tblattachletter',array('cl_id'=>$id));
		$attcount=$this->input->post('attid');
		for($i=0;$i<$attcount;$i++)
		{
			$val=$this->input->post('lt_temp'.$i);
			if(!empty($val)){
				 $this->mdl_general->SaveForm('tblattachletter',array('cl_id'=>$id,'lt_id'=>$val));

			}
		}
        $response=array(
            'status'=>'success',
            'message'=>'letter type updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/contractletter');
    }
//property tenure
	function propertytenure($edit=null,$id=null){
        if(!is_null($edit) && !is_null($id)){
            $page_details['page_title']="ONYX TECH | Payment Mode edit";
            $data['property_tenure_details']=$this->mdl_general->GetInfoByRow('tblpropertytenure','pt_id',array('pt_id'=>$id));
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('propertytenure_edit',$data);
			$this->load->module('footer')->index($page_details);

        }else{

			$page_details['page_title']="ONYX TECH | Payment Mode";
			$data['property_tenure_list']=$this->mdl_general->GetAllInfo('tblpropertytenure','pt_id');
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('propertytenure',$data);
			$this->load->module('footer')->index($page_details);
		}
    }

    function add_new_propertytenure(){
        $active=$this->input->post('pt_active');
        $form_data=array(

            'pt_name'=>$this->input->post('pt_name'),
            'pt_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->SaveForm('tblpropertytenure',$form_data);
        $response=array(
            'status'=>'success',
            'message'=>'letter type added successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/propertytenure');

    }

    function delete_propertytenure(){
        $id=$this->input->post('id');
        $this->mdl_general->Delete('tblpropertytenure',array('pt_id'=>$id));
        $response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
    }

    function propertytenure_edit(){
        $active=$this->input->post('pt_active');
        $id=$this->input->post('pt_id');
        $form_data=array(

            'pt_name'=>$this->input->post('pt_name'),
            'pt_active'=>( $active ? $active :'0')
        );
        $this->mdl_general->Manage('tblpropertytenure',$form_data,array('pt_id'=>$id),'Update');
        $response=array(
            'status'=>'success',
            'message'=>'letter type updated successfully'
            );
        $this->session->set_flashdata($response);
        redirect('setup/propertytenure');
    }


}