<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Dashboard extends MX_Controller{

	function __construct() {
        parent::__construct();
        $this->load->model('mdl_general');
        if($this->session->userdata('sess_logged_in')!=true){
    			redirect('login/index?error=4');
        }


    }

    function index(){
    	$page_details['page_title']='ONYX TECH | Dashboard';
        $this->load->Module('header')->index($page_details);
		$temp=$this->mdl_general->GetAllInfo('tblappointment','ap_id',array('ap_active'=>1));
		$data['appointment_count']=count($temp);
		$properties=$this->mdl_general->GetAllInfo('tblproperty','p_added',array('p_active'=>1));
		$data['property_count']=count($properties);
		$temp=$this->mdl_general->GetAllInfo('tbllandlord','c_id',array('c_active'=>1));
		$data['landlord_count']=count($temp);
		$tenants=$this->mdl_general->GetAllInfo('tbltenant','c_regdate',array('c_active'=>1));
		$data['tenant_count']=count($tenants);
		$temp=$this->mdl_general->GetAllInfo('tblagent','a_id',array('a_active'=>1));
		$data['agent_count']=count($temp);
		$temp=$this->mdl_general->GetAllInfo('tblenquiry','e_id',array('e_active'=>1));
		$data['enquiry_count']=count($temp);
		$contracts=$this->mdl_general->GetAllInfo('tblcontract','rc_id',array('rc_active'=>1));
		$data['contract_count']=count($contracts);
		
		
		$contracts=$this->mdl_general->GetAllInfo('tblservicenote','sn_id',array('sn_active'=>1));
		$data['service_note']=count($contracts);
		
	$date=date("Y-m-d");
	$query= $this->db->query("select count(*) as total from tblpays where ps_date <= '".$date."' ORDER BY ps_status asc, ps_date desc")->result_array();
		$data['rent_payment']=$query[0]['total'];
		
			//$query= $this->db->query("select * from tbllandlordnote where ln_date <= '".$date."' ORDER BY ln_status asc, ln_date desc")->result_array();

			$query1= $this->db->query("select count(*) as total from tbllandlordnote where ln_date <= '".$date."' ORDER BY ln_status asc, ln_date desc")->result_array();
		$data['landlord_note']=$query1[0]['total'];
		
		
		//rent chart
		$this->load->model('mdl_extra_dashboard');
		//tenant chart
		$thisyear = date("Y");
		$list = "[";
		for ($i=1;$i<=12;$i++){
			$sdate= date("Y-m-d", strtotime($thisyear."-".$i."-01"));
			$edate= date("Y-m-d", strtotime($thisyear."-".($i+1)."-01"));
			$pay= $this->mdl_extra_dashboard->GetTenantRent($sdate,$edate);
			if(empty($pay[0]['sum'])){
				$pay[0]['sum'] = 0;
			}
			$list.=$pay[0]['sum'];
			if($i != 12)
				$list .= ",";
		}
		$list .= "]";
		$data['tenantrentlist'] = $list;
		$data['year'] = $thisyear;

		//landlordchart
		$list = "[";
		for ($i=1;$i<=12;$i++){
			$sdate= date("Y-m-d", strtotime($thisyear."-".$i."-01"));
			$edate= date("Y-m-d", strtotime($thisyear."-".($i+1)."-01"));
			$pay= $this->mdl_extra_dashboard->GetLandlordNote($sdate,$edate);
			if(empty($pay[0]['sum'])){
				$pay[0]['sum'] = 0;
			}
			$list.=$pay[0]['sum'];
			if($i != 12)
				$list .= ",";
		}
		$list .= "]";
		$data['landlordnotelist'] = $list;
		//rent chart

		//recent tenants
		$rectenant=array();
		for($i=0;$i<min(8,count($tenants));$i++)
			$rectenant[]=$tenants[$i];
		$data['rectenant']=$rectenant;

		//recent properties
		$recproperty = array();
		for($i=0;$i<min(4,count($properties));$i++)
			$recproperty[]=$properties[$i];
		$data['recproperty']=$recproperty;

		//contracts
		$contractlist= array();
		for($i=0;$i<min(8,count($contracts));$i++)
		{
			$contractlist[]= $contracts[$i];
		}
		$data['contracts']=$contractlist;

		$lastrent=array();
		$lastrent=$this->mdl_general->GetAllInfo("tblpays","ps_paydate",null, 8);
		for($i=0;$i<min(8,count($lastrent));$i++)
		{
			if($lastrent[$i]['ps_paid'] == 0)
				continue;
			$rentlist[]= $lastrent[$i];
		}
		$data['rentlist']=$rentlist;


		$this->load->Module('sidebar')->index($page_details);
    	$this->load->view('dashboard',$data);
		//$this->load->Module('footer')->index($page_details);
    }

    function change_password(){
        $current_pass=$this->input->post('currentPassword');
        $new_pass=$this->input->post('newPassword');
        $confirm_pass=$this->input->post('confirmNewPassword');
        if($new_pass == $confirm_pass){
            //if new password is equal to confirm password
            //get user details
            $u_details=$this->mdl_general->GetInfoByRow('acs_user','u_id',array('u_id'=>$this->session->userdata('sess_user_id')));
            //check if the current password is correct
        if($u_details->u_password == $current_pass){
            //password match found and update password
            $this->mdl_general->Manage('acs_user',array('u_password'=>$new_pass),array('u_id'=>$this->session->userdata('sess_user_id')),'Update');
            $response=array(
                'status'=>'success',
                'message'=>'Password change successful'
                );
            //send response back to client
            $this->session->set_flashdata($response);
            redirect('dashboard');
        }else{
            //password doesnt match with database
            $response=array('status'=>'danger','message'=>'Incorrect password,try again!');
            $this->session->set_flashdata($response);
            redirect('dashboard');
        }


        }else{
            //new password is not equal to confirm password
            $response=array(
                'status'=>'danger',
                'message'=>'New password and Confirm password does not match'
                );
            $this->session->set_flashdata($response);
            redirect('dashboard');


        }
    }

}