<?php

namespace app\models;

use app\components\BaseActiveRecord;
use Yii;

class User extends BaseActiveRecord implements \yii\web\IdentityInterface
{

    const ADMIN = 'admin';

    public function rules()
    {
        return [
            [['password', 'name', 'email'], 'required', 'on'=>'admin_register'],
            [['email'], 'isExist', 'on' => 'admin_register'],
            [['password', 'email'], 'checkLogin', 'on' => 'login']
        ];
    }


    public function isExist($attribute, $params)
    {
        if(self::find()->where(['email' => $this->$attribute])->exists()) {
            $this->addError(
                $attribute,
                'User with this email already exist.'
            );
        }
    }

    public function checkLogin($attribute, $params)
    {
        $data = ['email' => $this->email, 'password' => $this->password];
        if(!self::find()->where($data)->exists()) {
            $this->addError(
                $attribute,
                'Email or password is wrong.'
            );
        }
    }


    /**
     * @inheritdoc
     */
    public static function findIdentity($id)
    {
        return self::findById($id);
    }

    /**
     * @inheritdoc
     */
    public static function findIdentityByAccessToken($token, $type = null)
    {
        return null;
    }

    /**
     * Finds user by username
     *
     * @param  string $email
     * @return static|null
     */
    public static function findByEmail($email)
    {
        return self::find()
            ->where([
                'email' => $email
            ])
            ->one();
    }

    public static function findById($id)
    {
        return self::find()
            ->where([
                'id' => $id
            ])
            ->one();
    }

    /**
     * @inheritdoc
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @inheritdoc
     */
    public function getAuthKey()
    {
        return $this->id . $this->userType;
    }


    public function isAdmin()
    {
        return $this->userType == self::ADMIN;
    }


    /**
     * @inheritdoc
     */
    public function validateAuthKey($authKey)
    {
        return $this->authKey === $authKey;
    }

    public static function encrypt($value)
    {
        return md5($value);
    }

    /**
     * Validates password
     *
     * @param  string  $password password to validate
     * @return boolean if password provided is valid for current user
     */
    public function validatePassword($password)
    {
        return $this->password === self::encrypt($password);
    }

    public function getErrorMessages()
    {
        $errors = $this->getErrors();
        $messages = [];
        foreach($errors as $error){
            $messages = array_merge($messages, $error);
        }
        return $messages;
    }
}
