<?php

namespace app\controllers;

use app\components\UserService;
use app\components\DeviceService;
use app\components\SettingService;
use app\components\SongService;
use app\models\Device;
use app\models\Setting;
use app\models\SongUploadForm;
use app\models\User;
use Yii;
use yii\filters\VerbFilter;
use app\components\BaseWebController;
use yii\web\UploadedFile;

class ApiController extends BaseWebController
{
    public $enableCsrfValidation = false;

    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'register' => ['post'],
                    'setting' => ['post'],
                    'upload-song' => ['post'],
                    'remove-song' => ['post'],
                    'ensure-device-registered' => ['post']
                ],
            ],
        ];
    }

    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ]
        ];
    }


    /*
     * GET
     */
    public function actionDevices()
    {
        $deviceService = new DeviceService();
        $devices = $deviceService->getDevices();

        return $this->json($devices);
    }

    /*
     * Admin registration
     *
     * POST
     */
    public function actionRegister()
    {
        $model = new User(['scenario' => 'admin_register']);
        $userService = new UserService();
        $post = json_decode(Yii::$app->request->rawBody, true);
        $formattedData = ['User' => $post];
        if ($model->load($formattedData) && $model->validate()) {
            $userService->saveAdmin($model);
            $result = ['status'=>'success'];
        } else {
            $result = ['status'=>'failed', 'errors' => $model->getErrorMessages()];
        }

        return $this->json($result);
    }


    /*
     *
     * POST
     */
    public function actionEnsureDeviceRegistered()
    {
        $model = new Device(['scenario' => 'registration']);
        $deviceService = new DeviceService();
        $post = json_decode(Yii::$app->request->rawBody, true);
        $formattedData = ['Device' => $post];
        if ($model->load($formattedData) && $model->validate()) {
            $res = $deviceService->saveDevice($model);
            $result = ['status'=>'success', 'device' => $res];
        } else {
            $result = ['status'=>'failed', 'errors' => $model->getErrors()];
        }

        return $this->json($result);
    }

    /*
     *
     * POST
     */
    public function actionUpdateGcmId()
    {
        $model = new Device(['scenario' => 'gcm_update']);
        $deviceService = new DeviceService();
        $post = json_decode(Yii::$app->request->rawBody, true);
        $formattedData = ['Device' => $post];
        if ($model->load($formattedData) && $model->validate()) {
            $deviceId = $post['device_id'];
            $deviceService->updateGcmId($deviceId, $model->gcm_id);
            $result = ['status'=>'success'];
        } else {
            $result = ['status'=>'failed', 'errors' => $model->getErrors()];
        }

        return $this->json($result);
    }

    /*
     *
     * GET
     */
    public function actionSendTestNotify()
    {
        $deviceService = new DeviceService();
        $deviceId = \Yii::$app->request->queryParams['device_id'];
        $event = \Yii::$app->request->queryParams['event'];
        $result = $deviceService->changeOccurred($deviceId, $event);
        return $this->json($result);
    }


    /*
     *
     * GET
     */
    public function actionSendTestNotify2()
    {
        $event = \Yii::$app->request->queryParams['event'];


        $registrationIds = [];
        $registrationIds[] = 'APA91bFuJ5F0cZ2NLssH15MvzXICSNJgRBZZ4UuqCs5A29eVqxv4dgtnoitr0VBpT-KQsh9jZKu0ePXyY8uIjxCVVpJtWZZGUaP7z5yNCMgrZvlMrR46vSPjWhuFs1zCIBnPBNeJw1zg5zULN_-RaaQIRycIMUcqixLSlKpe_ANJWJiK6ZGXtq8';



        switch ($event) {
            case "song_added":
                $setting = '{"settings":{"interval":15,"duration":7},
"songs":[
	{"id":26,"device_id":5,"path":"http://websockets.php.qarea.org/web/uploads/5/test3.mp3","name":"test3.mp3"}
	]}';
                break;
            case "song_removed":
                $setting = '{"settings":{"interval":15,"duration":7},
"songs":[
	{"id":26,"device_id":5,"path":"http://websockets.php.qarea.org/web/uploads/5/test3.mp3","name":"test3.mp3"}
	]}';
                break;
            case "setting_updated":
                $setting = '{"settings":{"interval":1,"duration":1},
"songs":[
	{"id":26,"device_id":5,"path":"http://websockets.php.qarea.org/web/uploads/5/test3.mp3","name":"test3.mp3"}
	]}';
                break;
        }

        $setting = json_decode($setting, true);


        $msg = [
            'event' => $event,
            'data' => $setting,
            'timestamp' => time()
        ];

        $fields = [
            'registration_ids' => $registrationIds,
            'data'             => $msg
        ];

        $headers = [
            'Authorization: key=' . \Yii::$app->params['google']['API_ACCESS_KEY'],
            'Content-Type: application/json'
        ];

        $ch = curl_init();
        curl_setopt(
            $ch, CURLOPT_URL, 'https://android.googleapis.com/gcm/send'
        );
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
        $result = curl_exec($ch);
        curl_close($ch);


        return $this->json($result);
    }

    /*
     * POST
     */
    public function actionLogin()
    {
        $model = new User(['scenario' => 'login']);
        $post = json_decode(Yii::$app->request->rawBody, true);
        $formattedData = ['User' => $post];
        if ($model->load($formattedData) && $model->validate()) {
            $userService = new UserService();
            $user = $userService->getUserByEmail($model->email);
            $result = ['status'=>'success', 'user' => $user->getAttributes()];
        } else {
            $result = ['status'=>'failed', 'errors' => $model->getErrors()];
        }

        return $this->json($result);
    }

    /*
     * POST
     */
    public function actionSetting()
    {
        $settingService = new SettingService();
        $model = new Setting();
        $post = json_decode(Yii::$app->request->rawBody, true);
        $formattedData = ['Setting' => $post];
        if ($model->load($formattedData) && $model->validate()) {
            $settingService->saveSetting($model);
            $result = ['status'=>'success'];
        } else {
            $result = ['status'=>'failed', 'errors' => $model->getErrors()];
        }

        return $this->json($result);
    }

    /*
     * GET
     */
    public function actionGetSetting()
    {
        $settingService = new SettingService();
        $deviceId = \Yii::$app->request->queryParams['device_id'];
        $setting = $settingService->getSetting($deviceId);
        $result = ['setting' => $setting];

        return $this->json($result);
    }

    /*
     * GET
     */
    public function actionGetSettingAndSong()
    {
        $settingService = new SettingService();
        $deviceID = \Yii::$app->request->queryParams['device_id'];
        $result = $settingService->getSettingAndSong($deviceID);

        return $this->json($result);
    }

    /*
     * POST
     */
    public function actionUploadSong()
    {
        $model = new SongUploadForm();
        $post = Yii::$app->request->post();
        $files = [];
        for($i=1; $i<=$post['files_count']; $i++) {
            $files['SongUploadForm[file]['.$i.']'] = $_FILES['file' . $i];
            unset($_FILES['file' . $i]);
        }
        $_FILES = $files;
        $model->file = UploadedFile::getInstances($model, 'file');
        if ($model->file && $model->validate()) {
            $songService = new SongService();
            $songService->saveSongs($post['device_id'], $model->file);
            $result = ['status'=>'success'];
        } else {
            $result = ['status'=>'failed', 'errors' => $model->getErrors()];
        }
        return $this->json($result);
    }

    /*
     * POST
     */
    public function actionRemoveSong()
    {
        $songService = new SongService();
        $post = json_decode(Yii::$app->request->rawBody, true);
        $songService->removeSong($post['songs']);
        $result = ['status'=>'success'];
        return $this->json($result);
    }

}
