<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "song".
 *
 * @property integer $id
 * @property integer $device_id
 * @property string $name
 */
class Song extends \app\components\BaseActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'song';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['device_id', 'name'], 'required'],
            [['device_id'], 'integer'],
            [['name'], 'string', 'max' => 255]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'device_id' => 'Device ID',
            'name' => 'Name',
        ];
    }
}
