<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "setting".
 *
 * @property integer $id
 * @property integer $device_id
 * @property integer $interval
 * @property string $start_hour
 * @property string $end_hour
 */
class Setting extends \app\components\BaseActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'setting';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['device_id', 'interval', 'duration', 'start_hour', 'end_hour'], 'required'],
            [['device_id'], 'isExist'],
            [['device_id', 'interval', 'duration'], 'integer'],
            [['start_hour', 'end_hour'], 'string', 'max' => 5],
            [['start_hour', 'end_hour'], 'string', 'min' => 4],
            [['start_hour', 'end_hour'], 'isRightHour'],
            ['start_hour', 'default', 'value' => '18:00'],
            ['end_hour', 'default', 'value' => '23:00']
        ];
    }

    public function isExist($attribute, $params)
    {
        if(!Device::find()->where(['id' => $this->device_id])->exists()) {
            $this->addError(
                $attribute,
                'User is not exist.'
            );
        }
    }

    public function isRightHour($attribute, $params)
    {
        $arrHour = explode(':', $this->getAttribute($attribute));
        $err = false;
        if (count($arrHour) != 2) {
            $err = true;
        } else {
            $h = intval($arrHour[0]);
            $m = intval($arrHour[1]);
            ($h < 0 || $h > 24 || $m < 0 || $m > 60) && $err = true;
        }
        if ($err) {
            $this->addError(
                $attribute,
                "Wrong time format in property {$attribute}"
            );
        }
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'device_id' => 'Device ID',
            'interval' => 'Interval',
            'start_hour' => 'Start Hour',
            'end_hour' => 'End Hour',
        ];
    }
}
