<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "device".
 *
 * @property integer $id
 * @property string $name
 * @property string $uuid
 * @property string $gcm_id
 */
class Device extends \app\components\BaseActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'device';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name', 'uuid'], 'required', 'on' => 'registration'],
            [['gcm_id'], 'required', 'on' => 'gcm_update'],
            [['name', 'uuid', 'gcm_id'], 'string', 'max' => 255]
        ];
    }



    public function getSongs()
    {
        return $this->hasMany(Song::className(), ['device_id' => 'id']);
    }


    public function getSetting()
    {
        return $this->hasOne(Setting::className(), ['device_id' => 'id']);
    }


    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'uuid' => 'Uuid',
            'gcm_id' => 'GCM id'
        ];
    }
}
