<?php

namespace app\components;

use app\models\Device;
use app\models\Setting;
use yii\helpers\Url;

class SettingService
{
    public function saveSetting(Setting $model)
    {
        $oldSetting = Setting::find()
            ->where([
                'device_id' => $model->device_id
            ])
            ->one();
        if ($oldSetting) {
            $oldSetting->setAttributes($model->getAttributes());
            $oldSetting->update();

            $deviceService = new DeviceService();
            $deviceService->changeOccurred($model->device_id, DeviceService::SETTING_UPDATED);
        } else {
            return $model->save();
        }
    }

    public function getSetting($deviceId)
    {
        return Setting::find()
            ->where([
                'device_id' => $deviceId
            ])
            ->one();
    }

    public function getSettingAndSong($deviceId)
    {
        $data = Device::find()
            ->with('songs')
            ->with('setting')
            ->where([
                'id' => $deviceId
            ])
            ->one();

        $result = [];
        $result['settings'] = [];
        if (isset($data->setting)) {
            $result['settings'] = [
                'interval' => $data->setting->interval,
                'duration' => $data->setting->duration,
                'start_hour' => $data->setting->start_hour,
                'end_hour' => $data->setting->end_hour,
            ];
        }
        $songs = [];
        if(isset($data->songs)) {
            foreach ($data->songs as $song) {
                $songs[] = [
                    'id'        => $song->id,
                    'device_id' => $song->device_id,
                    'path'      =>
                        Url::base(true) . '/uploads/' . $song->device_id . '/'
                        . $song->name,
                    'name'      => $song->name
                ];
            }
        }

        $result['songs'] = $songs;
        return $result;
    }
}