<?php

namespace app\components;

use app\models\Device;
use app\models\Setting;

class DeviceService
{
    const SETTING_UPDATED = 'setting_updated';
    const SONG_ADDED = 'song_added';
    const SONG_REMOVED = 'song_removed';


    public function saveDevice(Device $model)
    {
        $oldDevice = Device::find()
            ->where([
                'uuid' => $model->uuid
            ])
            ->one();
        if (!$oldDevice) {
            $model->save();
            $setting = new Setting();
            $setting->device_id = $model->id;
            $setting->save(false);
            return $model;
        }

        return $oldDevice;
    }

    public function getDevices()
    {
        return Device::find()->all();
    }

    public function updateGcmId($deviceId, $gcmId)
    {
        $device = Device::find()->where(['id' => $deviceId])->one();
        $device->gcm_id = $gcmId;
        return $device->update();
    }

    public function changeOccurred($deviceId, $event)
    {
        return $this->sendPushNotification($deviceId, $event);
    }

    protected function sendPushNotification($deviceId, $event)
    {
        $device = Device::find()->where(['id' => $deviceId])->one();
        if(!$device->gcm_id) {
            return false;
        }
        $registrationIds = [];
        $registrationIds[] = $device->gcm_id;

        $settingService = new SettingService();
        $setting = $settingService->getSettingAndSong($deviceId);

        $msg = [
            'event' => $event,
            'data' => $setting,
            'timestamp' => time()
        ];

        $fields = [
            'registration_ids' => $registrationIds,
            'data'             => $msg
        ];

        $headers = [
            'Authorization: key=' . \Yii::$app->params['google']['API_ACCESS_KEY'],
            'Content-Type: application/json'
        ];

        $ch = curl_init();
        curl_setopt(
            $ch, CURLOPT_URL, 'https://android.googleapis.com/gcm/send'
        );
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
    }

}