<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');


require './vendor/autoload.php';
use Parse\ParseClient;
use Parse\ParseObject;
use Parse\ParseQuery;
use Parse\ParseFile;
use Parse\ParseUser;
use Parse\ParseGeoPoint;

ParseClient::initialize(PARSE_APP_KEY, PARSE_REST_KEY, PARSE_MASTER_KEY);

class Order extends MX_Controller{

    function __construct() {
        parent::__construct();
        if($this->session->userdata('sess_logged_in')!=true){
                redirect('login/index?error=4');
        }
    }


	function index(){
		$data=array();
		$query = new ParseQuery("Order");
		$results = $query->find();
		$categorylist=array();
		$query = new ParseQuery("SubCategory");
		$categorylist=$query->find();
		$userlist=array();
		$query = ParseUser::query();
		$userlist = $query->find();
		$servantlist=array();
		$query = new ParseQuery("Servant");
		$servantlist=$query->find();

		$orderusers = array();
		$orderservants = array();
		$ordercategorys = array();
		foreach($results as $result){
			$subCateoryId=$result->get("orderCategoryId");
			$categoryname="";
			foreach($categorylist as $category){
				if($category->get("subCategoryId")==$subCateoryId){
					$categoryname=$category->get("name");
					break;
				}
			}
			$ordercategorys[$result->getObjectId()]=$categoryname;
			$username="";
			$userid=$result->get("userId");
			foreach($userlist as $user){
				if($user->getObjectId()==$userid){
					$username=$user->get("name");
					break;
				}
			}
			$orderusers[$result->getObjectId()]=$username;

			$servantname="";
			$servantid=$result->get("servantId");
			foreach($servantlist as $servant){
				if($servant->getObjectId()==$servantid){
					$servantname=$servant->get("name");
					break;
				}
			}
			$orderservants[$result->getObjectId()]=$servantname;
		}
		$data['orderlist']=$results;
		$data['userlist']=$orderusers;
		$data['servantlist']=$orderservants;
		$data['categorylist']=$ordercategorys;

		$page_details['page_title']='Order';
		$this->load->Module('header')->index($page_details);
		$this->load->view('order',$data);
		$this->load->Module('sidebar')->index($page_details);
		$this->load->Module('footer')->index($page_details);
		$this->load->Module('jscode')->order();
	}

	function delete_order(){
		$id=$this->input->post('id');
		$query = new ParseQuery("Order");
		$servant=$query->get(intval($id));
		$servant->destroy();
		$response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
	}

	function detail($id){
		$query = new ParseQuery("Order");
		$order=$query->get($id);
		$data['order']=$order;

		$query = new ParseQuery("SubCategory");
		$query->equalTo("subCategoryId",$order->get("orderCategoryId"));
		$categorylist=$query->find();
		$categoryname="";
		if(count($categorylist)>0){
			$category=$categorylist[0];
			$categoryname=$category->get("name");
		}
		$data['category']=$categoryname;

		$query = ParseUser::query();
		$user=$query->get($order->get("userId"));
		$data['user']=$user;

		$query = new ParseQuery("Servant");
		$servant=$query->get($order->get("servantId"));
		$data['servant']=$servant;

		$data['destloc']=$order->get("location");
		$data['servantloc']=$servant->get("currentLocation");

		$page_details['page_title']='Order - Detail';
		$this->load->Module('header')->index($page_details);
		$this->load->view('order_detail',$data);
		$this->load->Module('sidebar')->index($page_details);
		$this->load->Module('footer')->index($page_details);
		$this->load->Module('jscode')->order_detail();
	}

	function getservantposition(){
		//['Servant', servantlat, servantlong, 2]
		$id=$this->input->post('id');

		$query = new ParseQuery("Servant");
		$servant=$query->get($id);
		$loc=$servant->get("currentLocation");
		$data=array();
		$data['lat']=$loc->getLatitude();
		$data['long']=$loc->getLongitude();		
		echo json_encode($data);
	}
/*
	function edit($id){
		$categorylist=array();
		$query = new ParseQuery("SubCategory");
		$categorylist=$query->find();
		$data['categorylist']=$categorylist;
		$query = new ParseQuery("Order");
		$servant=$query->get($id);
		$data['servant']=$servant;
		$page_details['page_title']='Order - Edit';
		$this->load->Module('header')->index($page_details);
		$this->load->view('servant_edit',$data);
		$this->load->Module('sidebar')->index($page_details);
		$this->load->Module('footer')->index($page_details);
		$this->load->Module('jscode')->servant_edit();
	}

	function add(){
		$categorylist=array();
		$query = new ParseQuery("SubCategory");
		$categorylist=$query->find();
		$data['categorylist']=$categorylist;

		$userlist=array();
		$query = ParseUser::query();
		$userlist = $query->find();
		$data['userlist']=$userlist;

		$servantlist=array();
		$query = new ParseQuery("Servant");
		$servantlist=$query->find();
		$data['servantlist']=$servantlist;

		$page_details['page_title']='Order - Add';
		$this->load->Module('header')->index($page_details);
		$this->load->view('order_add',$data);
		$this->load->Module('sidebar')->index($page_details);
		$this->load->Module('footer')->index($page_details);
		$this->load->Module('jscode')->order_add();
	}

	function getservant(){
		$id=$this->input->post('id');
		$query = new ParseQuery("Servant");
		$query->equalTo("subCategoryId",intval($id));
		$servantlist=$query->find();
		$html="";
		foreach($servantlist as $servant){
			$html.="<option value='".$servant->getObjectId()."'>".$servant->get("name")."</option>";
		}
		echo $html;
	}

	function add_order(){
		$name=$this->input->post("name");
		$rating=$this->input->post("rating");
		$email=$this->input->post("email");
		$status=$this->input->post("status");
		$subcategory=$this->input->post("subCategory");
		$urgent=false;
		if(!empty($_POST["urgent"])){
			$urgent=true;
		}
		if ( isset( $_FILES['image'] ) ) {
			$file = ParseFile::createFromData( file_get_contents( $_FILES['image']['tmp_name'] ), $_FILES['image']['name']  );
			//echo($file);
			$file->save();
			
		}

		$query = new ParseQuery("Order");
		$servant= new ParseObject("Order");
		$servant->set("name",$name);
		$servant->set("rating",floatval($rating));
		$servant->set("email",$email);
		$servant->set("currentStatus",$status);
		$servant->set("subCategoryId",intval($subcategory));
		if(!empty($file))
			$servant->set("photo",$file);
		$servant->save();
		redirect('servant');
	}
	function edit_order(){
		$id= $this->input->post("id");
		$name=$this->input->post("name");
		$rating=$this->input->post("rating");
		$email=$this->input->post("email");
		$status=$this->input->post("status");
		$subcategory=$this->input->post("subCategory");
		$urgent=false;
		if(!empty($_POST["urgent"])){
			$urgent=true;
		}

		if ( !empty( $_FILES['image']['tmp_name'] ) ) {
			$file = ParseFile::createFromData( file_get_contents( $_FILES['image']['tmp_name'] ), $_FILES['image']['name']  );
			//echo($file);
			$file->save();
			
		}

		$query = new ParseQuery("Order");
		$servant=$query->get($id);
		$servant->set("name",$name);
		$servant->set("rating",floatval($rating));
		$servant->set("email",$email);
		$servant->set("currentStatus",$status);
		$servant->set("subCategoryId",intval($subcategory));
		if(!empty($file))
			$servant->set("photo",$file);
		$servant->save();
		redirect('servant');
	}
*/
}