<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');


require './vendor/autoload.php';
use Parse\ParseClient;
use Parse\ParseObject;
use Parse\ParseQuery;
use Parse\ParseFile;
use Parse\ParseUser;

ParseClient::initialize(PARSE_APP_KEY, PARSE_REST_KEY, PARSE_MASTER_KEY);

class Client extends MX_Controller{

    function __construct() {
        parent::__construct();
        if($this->session->userdata('sess_logged_in')!=true){
                redirect('login/index?error=4');
        }
    }

	function index(){
		$data=array();
		$query = ParseUser::query();
		$results = $query->find();
		$data['clientlist']=$results;
		$page_details['page_title']='Client';
		$this->load->Module('header')->index($page_details);
		$this->load->view('client',$data);
		$this->load->Module('sidebar')->index($page_details);
		$this->load->Module('footer')->index($page_details);
		$this->load->Module('jscode')->client();
	}

	function edit($id){
		$query = ParseUser::query();
		$client=$query->get($id);
		$data['client']=$client;
		$page_details['page_title']='Client - Edit';
		$this->load->Module('header')->index($page_details);
		$this->load->view('client_edit',$data);
		$this->load->Module('sidebar')->index($page_details);
		$this->load->Module('footer')->index($page_details);
		$this->load->Module('jscode')->client_edit();
	}

	function add(){	
		$page_details['page_title']='Client - Add';
		$this->load->Module('header')->index($page_details);
		$this->load->view('client_add');
		$this->load->Module('sidebar')->index($page_details);
		$this->load->Module('footer')->index($page_details);
		$this->load->Module('jscode')->client_add();
	}

	function delete_client(){
		$id=$this->input->post('id');
		$query = ParseUser::query();
		$client=$query->get($id);
		$client->destroy(true);
		$response=array(
            'status'=>'success',
            'message'=>'deleted successfully'
            );
        echo json_encode($response);
	}

	function add_client(){
		$name=$this->input->post("name");
		$email=$this->input->post("email");
		if ( isset( $_FILES['image'] ) ) {
			$file = ParseFile::createFromData( file_get_contents( $_FILES['image']['tmp_name'] ), $_FILES['image']['name']  );
			$file->save();
		}

		$client= new ParseUser();
		$client->set("name",$name);
		$client->set("email",$email);
		$client->set("password","111");
		$client->set("username",$email);
		if(!empty($file))
			$client->set("photo",$file);
		$client->signUp();
		redirect('client');
	}
	function edit_client(){
		$id= $this->input->post("id");
		$name=$this->input->post("name");
		$email=$this->input->post("email");
		
		if ( !empty( $_FILES['image']['tmp_name'] ) ) {
			$file = ParseFile::createFromData( file_get_contents( $_FILES['image']['tmp_name'] ), $_FILES['image']['name']  );
			$file->save();
		}

		$query = ParseUser::query();
		$client=$query->get($id);
		$client->set("name",$name);
		$client->set("email",$email);
		$client->set("username",$email);
		if(!empty($file))
			$client->set("photo",$file);
		$client->save(true);
		redirect('client');
	}
}