<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Dashboard extends MX_Controller{

	function __construct() {
        parent::__construct();
        $this->load->model('mdl_general');
        if($this->session->userdata('sess_logged_in')!=true){
    			redirect('login/index?error=4');
        }


    }

    function index(){
    	$page_details['page_title']='ONYX TECH | Dashboard';
        $this->load->Module('header')->index($page_details);
		$temp=$this->mdl_general->GetAllInfo('tblappointment','ap_id',array('ap_active'=>1));
		$data['appointment_count']=count($temp);
		$temp=$this->mdl_general->GetAllInfo('tblproperty','p_id',array('p_active'=>1));
		$data['property_count']=count($temp);
		$temp=$this->mdl_general->GetAllInfo('tbllandlord','c_id',array('c_active'=>1));
		$data['landlord_count']=count($temp);
		$temp=$this->mdl_general->GetAllInfo('tbltenant','c_id',array('c_active'=>1));
		$data['tenant_count']=count($temp);
		$temp=$this->mdl_general->GetAllInfo('tblagent','a_id',array('a_active'=>1));
		$data['agent_count']=count($temp);
		$temp=$this->mdl_general->GetAllInfo('tblenquiry','e_id',array('e_active'=>1));
		$data['enquiry_count']=count($temp);
		$temp=$this->mdl_general->GetAllInfo('tblcontract','rc_id',array('rc_active'=>1));
		$data['contract_count']=count($temp);

    	$this->load->view('dashboard',$data);
		$this->load->Module('sidebar')->index($page_details);
		$this->load->Module('footer')->index($page_details);
    }

    function change_password(){
        $current_pass=$this->input->post('currentPassword');
        $new_pass=$this->input->post('newPassword');
        $confirm_pass=$this->input->post('confirmNewPassword');
        if($new_pass == $confirm_pass){
            //if new password is equal to confirm password
            //get user details
            $u_details=$this->mdl_general->GetInfoByRow('acs_user','u_id',array('u_id'=>$this->session->userdata('sess_user_id')));
            //check if the current password is correct
        if($u_details->u_password == $current_pass){
            //password match found and update password
            $this->mdl_general->Manage('acs_user',array('u_password'=>$new_pass),array('u_id'=>$this->session->userdata('sess_user_id')),'Update');
            $response=array(
                'status'=>'success',
                'message'=>'Password change successful'
                );
            //send response back to client
            $this->session->set_flashdata($response);
            redirect('dashboard');
        }else{
            //password doesnt match with database
            $response=array('status'=>'danger','message'=>'Incorrect password,try again!');
            $this->session->set_flashdata($response);
            redirect('dashboard');
        }


        }else{
            //new password is not equal to confirm password
            $response=array(
                'status'=>'danger',
                'message'=>'New password and Confirm password does not match'
                );
            $this->session->set_flashdata($response);
            redirect('dashboard');


        }
    }

}