<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Batch extends MX_Controller{

    function __construct() {
        parent::__construct();
        $this->load->model('mdl_general');
		$this->load->helper(array('form', 'url'));
	    $this->load->library('session');
	    $this->load->database();
    }

	public function install() {
//		batch::install();
//		exit;
	}

	public function uninstall() {
//		batch::uninstall();
//		exit;
	}

	public function run() {
//		batch::run();
//		exit;
	}

	public function index() {
		set_time_limit(5*60*1000);

		$this->contract_reminder();
	}

	public function contract_reminder(){
		$reminders=$this->mdl_general->GetAllInfo('tblreminder','r_id');
		foreach($reminders as $reminder){
			if((strtotime($reminder['r_date'])-time())<0){
				$mode= $reminder['r_mode'];
				$content= $reminder['r_content'];
				$rcid= $reminder['rc_id'];
				$this->mdl_general->Delete('tblreminder',array('r_id' =>$reminder['r_id']));
				$contracts=$this->mdl_general->GetAllInfo('tblcontract','rc_id',array('rc_id'=>$rcid));
				if(count($contracts)>0){
					$contract=$contracts[0];
					$tenant_id= $contract['t_id'];
					$tenants=$this->mdl_general->GetAllInfo('tbltenant','c_id',array('c_id'=>$tenant_id));
					if(count($tenants)>0){
						$tenant=$tenants[0];
						if($mode == 1){
							//send sms
							//echo ("send sms to ".$tenant['c_mobile1']." ".$content);
							$this->sendSMS($tenant['c_mobile1'],$content);
						} else if ($mode == 2){
							//send email
							//echo "send email to ".$tenant['c_email']." ".$content;
							$this->sendEmail($tenant['c_email'],$content);
						} else if ($mode == 3){
							//post not required
						}

					}

				}
				//send mail or email
			}
		}
	}

	//send email form

	function sendEmail($receiver=null,$message=null){

		$attaches=array();
		$sender=$this->mdl_general->GetInfoByRow('acs_configration','config_id',array('config_id'=>"1"));
        $this->load->library('email');
        $subject="Reminder";
		$config['useragent']  = "Onyx Tech";
		$config['mailpath']  = "/usr/sbin/sendmail"; // or "/usr/sbin/sendmail"
		$config['protocol']   = "sendmail";
		$config['mailtype'] = 'html';
		$config['charset']  = 'utf-8';
		$config['newline']  = "\r\n";
		$config['wordwrap'] = TRUE;
		$config['validate']=TRUE;
		$this->email->initialize($config);
		$this->email->from($sender->emailsenderaddress,$sender->emailsendername);
		$this->email->to($receiver);
		$this->email->subject($subject);
		$this->email->message($message);
/*		if($propcount>0){
			for($i=0;$i<$propcount;$i++){
				$this->email->attach(FCPATH.'src/tmp/'.$attaches[$i]);
			}
		}*/

		if($this->email->send()){
			$deliveryStatus.="Email has been sent to:".$to."<br />";
		}else{
			$deliveryStatus.="Email sending failed to:".$to."<br />";
		}

		$this->email->clear();
     }
//send mail form for SMS
	function sendSMS($receiver=null,$message=null){
		$url = "http://www.voodoosms.com/vapi/server/sendSMS?";
		 //Post variable names should be same as mentioned below example and its case sensitive as well
		$message=urlencode($message);
		$url .='dest=44'.$receiver;
		$url .='&orig=Ucare';
		$url .='&msg='.$message;
		$url .='&uid=pms';
		$url .='&pass=wfcsuj6';
		$url .='&validity=1';
		$url .='&format=php';

		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$response = curl_exec($ch);
		curl_close($ch);
		$delivered_sms="SMS has been sent. <br />";
    }

	
}