<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Login extends MX_Controller{
	function __construct() {
        parent::__construct();
        $this->load->model('mdl_general');


    }

    function index(){
        if($this->session->userdata('sess_logged_in')==true){
            redirect('dashboard');
        }
    	$data['page_title']='Ordering';
    	$this->load->view('login',$data);

    }

    function do_login(){
		$email=strtolower(trim($this->input->post('user_email')));
		$password=strtolower(trim($this->input->post('user_pass')));
		$user=$this->mdl_general->GetInfoByRow('mstuser','id',array('email'=>$email,'passwd'=>$password));
		$session_set_value = $this->session->all_userdata();

		if (isset($session_set_value['remember']) && $session_set_value['remember'] == "1") {
			$this->load->view('dashboard');
		}

        if($user){//user available in database
			$remember = $this->input->post('remember');
			if($remember){
				$this->session->set_userdata('remember', true);
			}

			$session_data=array(
				'sess_user_id'=>$user->id,
				'sess_user_name'=>$user->name,
				'sess_user_email'=>$user->email,
				'sess_user_username'=>$user->user_name,
				'sess_user_type'=>$user->user_group,
				'sess_logged_in'=>true
				);
			$this->session->set_userdata($session_data);
			redirect('dashboard');

    	}else{//username not available in database
    		redirect('login/index?error=1');
    	}
    }

    function logout(){
    	//unsetting data from session and redirect to login page
    	$session_data=array(
    		'sess_user_id'=>'',
    		'sess_user_name'=>'',
    		'sess_logged_in'=>false
    		);
    	$this->session->set_userdata($session_data);
    	redirect('login');
	}
}