<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Mdl_services extends CI_Model {

	function __construct() {
        parent::__construct();
    }

    function GetAvailableServices(){
    	$this->db->distinct();
        return $this->db
        		->select('dn_services.*, dn_service_categories.name AS category_name,dn_service_categories.id AS category_id')
        		->from('dn_services')
        		->join('dn_services_providers', 
        				'dn_services_providers.id_services = dn_services.service_id', 'inner')
                ->join('dn_service_categories',
                        'dn_service_categories.id = dn_services.id_service_categories', 'left')
        		->get()->result_array();
    }

    public function get_row($service_id) {
        if (!is_numeric($service_id)) {
            throw new Exception('$service_id argument is not an numeric (value: "' . $service_id . '")');
        }
        return $this->db->get_where('dn_services', array('service_id' => $service_id))->row_array();
    }
    
}