<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Report extends MX_Controller{

    function __construct() {
        parent::__construct();
        $this->load->model('mdl_general');
        if($this->session->userdata('sess_logged_in')!=true){
                redirect('login/index?error=4');
        }
		 date_default_timezone_set('GMT');
    }

	function propertylist(){
		$page_details['page_title']="ONYX TECH | Property List";
		$this->load->module('header')->index($page_details);
		$this->load->module('sidebar')->index($page_details);
		$this->load->view('propertylist_index');
		$this->load->module('footer')->index($page_details);
	}

	function rep_propertylist(){        
		$city=$this->input->post('city');
		$area=$this->input->post('area');
		$status=$this->input->post('status');

		$where=array("p_active"=>1);
		if($city !=0){
			$where["p_town"]=$city;
		}
		if($area !=0){
			$where["p_area"]=$area;
		}
		if($status !=0){
			$where["p_status"]=$status;
		}
		$data['city']=$city;
		$data['area']=$area;
		$data['status']=$status;
		$data['props']=$this->mdl_general->GetAllInfo('tblproperty','p_id',$where);
		if($this->input->post('email')){
			$this->load->view('report_propertylist_email',$data);
		}elseif($this->input->post('pdf')){
			$this->load->view('report_propertylist_pdf',$data);
		}elseif($this->input->post('xls')){
			$this->load->view('report_propertylist_xls',$data);
        }
	}

	function tenantlist(){
		$page_details['page_title']="ONYX TECH | Tenant List";
		$this->load->module('header')->index($page_details);
		$this->load->module('sidebar')->index($page_details);
		$this->load->view('tenantlist_index');
		$this->load->module('footer')->index($page_details);
	}

	function rep_tenantlist(){        
		$city=$this->input->post('city');
		$area=$this->input->post('area');

		$where=array("c_active"=>1);
		if($city !=0){
			$where["c_city"]=$city;
		}
		/*
		if($area !=0){
			$where["c_area"]=$area;
		}
		$data['area']=$area;*/

		$data['city']=$city;

		$data['props']=$this->mdl_general->GetAllInfo('tbltenant','c_id',$where);
		if($this->input->post('email')){
			$this->load->view('report_tenantlist_email',$data);
		}elseif($this->input->post('pdf')){
			$this->load->view('report_tenantlist_pdf',$data);
		}elseif($this->input->post('xls')){
			$this->load->view('report_tenantlist_xls',$data);
        }
	}
	function landproplist(){
		$page_details['page_title']="ONYX TECH | Tenant List";
		$this->load->module('header')->index($page_details);
		$this->load->module('sidebar')->index($page_details);
		$this->load->view('landlordpropertylist_index');
		$this->load->module('footer')->index($page_details);
	}

	function rep_landproplist(){        
		$city=$this->input->post('city');
		$area=$this->input->post('area');
		$landlord=$this->input->post('landlord');
		$status=$this->input->post('status');

		$where=array("p_active"=>1);
		if($city !=0){
			$where["p_town"]=$city;
		}
		if($area !=0){
			$where["p_area"]=$area;
		}
		if($status !=0){
			$where["p_status"]=$status;
		}
		if($landlord !=0){
			$where["p_oid"]=$landlord;
		}
		$data['city']=$city;
		$data['area']=$area;
		$data['status']=$status;
		$data['landinfo']=$this->mdl_general->GetInfoByRow('tbllandlord','c_id',array('c_id'=>$landlord));
		$data['props']=$this->mdl_general->GetAllInfo('tblproperty','p_id',$where);
		if($this->input->post('email')){
			$this->load->view('report_landlordpropertylist_email',$data);
		}elseif($this->input->post('pdf')){
			$this->load->view('report_landlordpropertylist_pdf',$data);
		}elseif($this->input->post('xls')){
			$this->load->view('report_landlordpropertylist_xls',$data);
        }
	}

	function get_area(){
		$city=$this->input->post("city");
		$info= $this->mdl_general->GetAllInfo('tblarea','a_id',array('a_city'=>$city));
		echo json_encode($info);
	}
    
    function renthistory($pid=0){
		$page_details['page_title']="ONYX TECH | Rent History";
        if($pid) {
            $data['contract_list']=$this->mdl_general->GetAllInfo('tblcontract','rc_id',array('p_id'=>$pid));            
        } else {
            $data['contract_list']=$this->mdl_general->GetAllInfo('tblcontract','rc_id');
        }
        $data['pid'] = $pid;
        $this->load->module('header')->index($page_details);
        $this->load->module('sidebar')->index($page_details);
        $this->load->view('renthistory',$data);
        $this->load->module('footer')->index($page_details);
        
    }
    function repPropPDF(){
        $pid=$this->input->post('property');
        if($pid == 0){
            return 0;
        }
        $list=$this->mdl_general->GetAllInfoASC('tblcontract','rc_id',array('p_id'=>$pid));
        $propinfo=$this->mdl_general->GetInfoByRow('tblproperty','p_id',array('p_id'=>$pid,'p_active' =>1));
        $data['propinfo']=$propinfo;
        $data['rentlist']=$list;
        $this->load->view('report_renthistory_pdf',$data);
    }

	function recrent(){
		$page_details['page_title']="ONYX TECH | Received Rent";
		$fdate= $this->input->post("fdate");
		$tdate= $this->input->post("tdate");
		$type= $this->input->post("submit");

		if(empty($fdate))
			$fdate=date("Y-m-d");
		
		if(empty($tdate))
			$tdate=date("Y-m-d");

		if(empty($type))
			$type="form";

		$fdate=date("Y-m-d",strtotime($fdate));
		$tdate=date("Y-m-d",strtotime($tdate));

		if(strtotime($fdate)>strtotime($tdate)){
			$temp=$fdate;
			$fdate=$tdate;
			$tdate=$temp;			
		}

		$this->load->model("mdl_extra_report");
		$list=$this->mdl_extra_report->GetRecRent($fdate,$tdate);
		$data['rentlist']= $list;
		$data['fdate'] = $fdate;
		$data['tdate'] = $tdate;

		if($type=="form"){
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('recrent_index',$data);
			$this->load->module('footer')->index($page_details);
		} else if ($type=="pdf"){
			$this->load->view('recrent_pdf',$data);
		}
	}

	function outrent(){
		$page_details['page_title']="ONYX TECH | Rent Outstandings";
		$fdate= $this->input->post("fdate");
		$tdate= $this->input->post("tdate");
		$type= $this->input->post("submit");

		if(empty($fdate))
			$fdate=date("Y-m-d");
		
		if(empty($tdate))
			$tdate=date("Y-m-d");

		if(empty($type))
			$type="form";

		$fdate=date("Y-m-d",strtotime($fdate));
		$tdate=date("Y-m-d",strtotime($tdate));

		if(strtotime($fdate)>strtotime($tdate)){
			$temp=$fdate;
			$fdate=$tdate;
			$tdate=$temp;			
		}

		$this->load->model("mdl_extra_report");
		$list=$this->mdl_extra_report->GetOutRent($fdate,$tdate);
		$data['rentlist']= $list;
		$data['fdate'] = $fdate;
		$data['tdate'] = $tdate;

		if($type=="form"){
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('outrent_index',$data);
			$this->load->module('footer')->index($page_details);
		} else if ($type=="pdf"){
			$this->load->view('outrent_pdf',$data);
		}
	}

	function outtenant(){
		$page_details['page_title']="ONYX TECH | Outstandings";
		$fdate= $this->input->post("fdate");
		$tdate= $this->input->post("tdate");
		$type= $this->input->post("submit");

		if(empty($fdate))
			$fdate=date("Y-m-d");
		
		if(empty($tdate))
			$tdate=date("Y-m-d");

		if(empty($type))
			$type="form";

		$fdate=date("Y-m-d",strtotime($fdate));
		$tdate=date("Y-m-d",strtotime($tdate));

		if(strtotime($fdate)>strtotime($tdate)){
			$temp=$fdate;
			$fdate=$tdate;
			$tdate=$temp;			
		}

		$this->load->model("mdl_extra_report");
		$list=$this->mdl_extra_report->GetOutRent($fdate,$tdate);
		$data['rentlist']= $list;
		$data['fdate'] = $fdate;
		$data['tdate'] = $tdate;

		if($type=="form"){
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('outrenttenant_index',$data);
			$this->load->module('footer')->index($page_details);
		} else if ($type=="pdf"){
			$this->load->view('outrenttenant_pdf',$data);
		}
	}

	function outlandlord(){
		$page_details['page_title']="ONYX TECH | Outstandings";
		$fdate= $this->input->post("fdate");
		$tdate= $this->input->post("tdate");
		$type= $this->input->post("submit");

		if(empty($fdate))
			$fdate=date("Y-m-d");
		
		if(empty($tdate))
			$tdate=date("Y-m-d");

		if(empty($type))
			$type="form";

		$fdate=date("Y-m-d",strtotime($fdate));
		$tdate=date("Y-m-d",strtotime($tdate));

		if(strtotime($fdate)>strtotime($tdate)){
			$temp=$fdate;
			$fdate=$tdate;
			$tdate=$temp;			
		}

		$this->load->model("mdl_extra_report");
		$list=$this->mdl_extra_report->GetOutLandlordNote($fdate,$tdate);
		$data['rentlist']= $list;
		$data['fdate'] = $fdate;
		$data['tdate'] = $tdate;

		if($type=="form"){
			$this->load->module('header')->index($page_details);
			$this->load->module('sidebar')->index($page_details);
			$this->load->view('outlandlordnote',$data);
			$this->load->module('footer')->index($page_details);
		} else if ($type=="pdf"){
			$this->load->view('outlandlordnote_pdf',$data);
		}
	}

}

