<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Mdl_appointments extends CI_Model {

	function __construct() {
        parent::__construct();
    }

    public function get_batch($where_clause = '') {
        if ($where_clause != '') {
            $this->db->where($where_clause);
        }
        
        return $this->db->get('dn_appointments')->result_array();
    }

    public function generate_hash() {
        $current_date = new DateTime();
        return md5($current_date->getTimestamp());
    }

    public function add($appointment) {
        // Validate the appointment data before doing anything.
        //$this->validate($appointment);
        
        // Perform insert() or update() operation.
        if (!isset($appointment['id'])) {
            $appointment['id'] = $this->insert($appointment);
        } else {
            $this->update($appointment);
        }

        return $appointment['id'];
    }

    private function insert($appointment) {
        $appointment['book_datetime'] = date('Y-m-d H:i:s');
        $appointment['hash'] = $this->generate_hash();
        
        if (!$this->db->insert('dn_appointments', $appointment)) {
            throw new Exception('Could not insert appointment record.');
        }
        
        return intval($this->db->insert_id());
    }

    private function update($appointment) {
        $this->db->where('id', $appointment['id']);
        if (!$this->db->update('dn_appointments', $appointment)) {
            throw new Exception('Could not update appointment record.');
        }
    }

    public function get_row($appointment_id) {
        if (!is_numeric($appointment_id)) {
            throw new Exception('Invalid argument given. Expected ' 
                    . 'integer for the $appointment_id : ' . $appointment_id);
        }
        return $this->db->get_where('dn_appointments', 
                array('id' => $appointment_id))->row_array();
    }
}